/* 
   NSDPSContextWindow.h

   Encapsulation of Display Postscript context window ops

   Copyright (C) 1999 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@gnu.org>
   Date: Oct 1999
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_NSDPSContextWindow
#define _GNUstep_H_NSDPSContextWindow

/* Define this to avoid including redefinitions of ps functions introduced
   by NSGraphicsContext */
#define _PSOperators_h_INCLUDE

#define BOOL XWINDOWSBOOL	// prevent X windows BOOL
#include <X11/Xmd.h>		// warning
#undef BOOL
#include <gnustep/xdps/NSDPSContext.h>

//
// WindowMaker window manager interaction
//
typedef struct {
    CARD32 flags;
    CARD32 window_style;
    CARD32 window_level;
    CARD32 reserved;
    Pixmap miniaturize_pixmap;		// pixmap for miniaturize button
    Pixmap close_pixmap;		// pixmap for close button
    Pixmap miniaturize_mask;		// miniaturize pixmap mask
    Pixmap close_mask;			// close pixmap mask
    CARD32 extra_flags;
} GNUstepWMAttributes;

#define GSWindowStyleAttr	(1<<0)
#define GSWindowLevelAttr	(1<<1)
#define GSMiniaturizePixmapAttr (1<<3)
#define GSClosePixmapAttr	(1<<4)
#define GSMiniaturizeMaskAttr	(1<<5)
#define GSCloseMaskAttr		(1<<6)
#define GSExtraFlagsAttr	(1<<7)

#define GSDocumentEditedFlag			(1<<0)
#define GSWindowWillResizeNotificationsFlag	(1<<1)
#define GSWindowWillMoveNotificationsFlag 	(1<<2)
#define GSNoApplicationIconFlag			(1<<5)
#define WMFHideOtherApplications		10
#define WMFHideApplication			12

typedef struct _gswindow_device_t {
  Window                ident;
  Window                root;
  Window		parent;
  int                   screen;
  GC                    gc;
  long                  number;
  int                   depth;
  int                   border;
  int			map_state;
  NSBackingStoreType    type;
  NSRect                xframe;
  Drawable              buffer;
  Drawable	        alpha_buffer;
  BOOL			is_exposed;
  NSMutableArray	*exposedRects;
  Region		region;		// Used between several expose events
  XWMHints		gen_hints;
  XSizeHints		siz_hints;
  GNUstepWMAttributes	win_attrs;
  XSetWindowAttributes	xwn_attrs;
  int			xoff;
  int			yoff;
  int			boff;
  Atom			protocols[4];
} gswindow_device_t;

@interface NSDPSContext (DPSWindow)
+ (gswindow_device_t *) _windowForXWindow: (Window)xWindow;
+ (gswindow_device_t *) _windowWithTag: (int)windowNumber;
- (void) _addExposedRectangle: (XRectangle)rectangle : (int)win;
- (void) _processExposedRectangles: (int)win;
@end

#endif
