# This package is not relocatable
%define ver	0.6.0
%define prefix 	/usr
%define gsr 	%{prefix}/GNUstep
Name: 		gnustep-core
Version: 	%{ver}
Release: 	1
Source: 	ftp://ftp.gnu.org/gnu/gstep/gstep-core-%{ver}.tar.gz
Copyright: 	LGPL/GPL
Group: 		Development
Summary: 	GNUstep core development package
Packager:	Red Hat Contrib|Net <rhcn-bugs@redhat.com>
Distribution:	Red Hat Contrib|Net
Vendor:		The Seawood Project
URL:		http://www.gnustep.org/
BuildRoot: 	/var/tmp/build-%{name}
Obsoletes: 	gnustep-base gnustep-gui gnustep-make gnustep-xraw gnustep-xgps
Provides: 	gnustep-base gnustep-gui gnustep-make gnustep-xgps
Prereq: 	/sbin/chkconfig /sbin/ldconfig

%description
   GNUstep is a general-purpose Objective-C developement system based on the
OpenStep standard developed by NeXT (now Apple) Inc. The libraries
consist of everything from foundation classes, such as dictionaries and
arrays, to GUI interface classes such as windows, sliders, buttons, etc.

This package is built with library-combo gnu-gnu-gnu-xgps.

%prep
%setup -q -n gstep-%{ver}

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{gsr}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}%{gsr}
mkdir -p ${RPM_BUILD_ROOT}/etc/profile.d
mkdir -p ${RPM_BUILD_ROOT}%{gsr}/Local

for i in 1 2 3 4 5 6 7 8; do
    mkdir -p ${RPM_BUILD_ROOT}%{gsr}/Library/man/man$i
done

make install GNUSTEP_INSTALLATION_DIR=${RPM_BUILD_ROOT}%{gsr} INSTALL_ROOT_DIR=${RPM_BUILD_ROOT}

# We'll replace this during the install phase
echo 'GMT' > ${RPM_BUILD_ROOT}%{gsr}/Libraries/Resources/NSTimeZones/localtime

# Create doc dirs & install documentation
for i in make base gui xgps ; do
    mkdir -p ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/$i
done

(cd $n && tar -cBpzf Testing.tar.gz Testing )

cp -pr ANNOUNCE COPYING* ChangeLog FAQ GNUstep-HOWTO INSTALL NEWS README Testing.tar.gz Version  ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/

(cd base && cp -pr ANNOUNCE AUTHORS COPYING* ChangeLog* INSTALL* NEWS README* Version ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/base/)

(cd gui && cp -pr ANNOUNCE COPYING* ChangeLog* FAQ INSTALL NEWS README SUPPORT Version ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/gui/)

(cd make && cp -pr COPYING ChangeLog DESIGN README ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/make)

(cd xgps && cp -pr COPYING* ChangeLog FAQ INSTALL README Version ${RPM_BUILD_ROOT}${RPM_DOC_DIR}/%{name}-%{ver}/xgps)

tmp1=`./make/config.guess`
tmp2=`./make/cpu.sh $tmp1`
tmp3=`./make/vendor.sh $tmp1`
tmp4=`./make/os.sh $tmp1`
tmp5=`./make/clean_cpu.sh $tmp2`
tmp6=`./make/clean_vendor.sh $tmp3`
tmp7=`./make/clean_os.sh $tmp4`

%ifos Linux
# Create profile files
cat > mygnustep.sh << EOF
#!/bin/sh
. %{gsr}/Makefiles/GNUstep.sh
EOF

cat > mygnustep.csh << EOF
#!/bin/csh
source %{gsr}/Makefiles/GNUstep.csh
EOF

mv mygnustep.sh $RPM_BUILD_ROOT/etc/profile.d/GNUstep.sh
mv mygnustep.csh $RPM_BUILD_ROOT/etc/profile.d/GNUstep.csh

cat > mygnustep.init.in << EOF
#!/bin/sh
#
# gnustep daemons
#
# chkconfig: 2345 35 65
# description: Starts gnustep daemons
#
# Source function library.
. /etc/rc.d/init.d/functions

case "\$1" in
  start)
	echo -n "Starting gnustep services: "
	daemon %{gsr}/Tools/GSARCH/GSOS/gdomap
	echo
	touch /var/lock/subsys/gnustep
	;;

  stop)
	echo -n "Stopping gnustep services: "
	killproc gdomap
	echo
	rm -f /var/lock/subsys/gnustep
	;;

   status)
	status gdomap	
	;;

   restart|reload)
	\$0 stop
	\$0 start
	;;

    *)
	echo "Usage: gnustep {start|stop|status|restart|reload}"
	exit 1
esac 
EOF

sed -e "s|GSARCH|${tmp5}|g" -e "s|GSOS|${tmp7}|g" < mygnustep.init.in > mygnustep.init

mkdir -p ${RPM_BUILD_ROOT}/etc/rc.d/init.d
mv mygnustep.init ${RPM_BUILD_ROOT}/etc/rc.d/init.d/gnustep
%endif

# Create filelist
cat > filelist.rpm.in << EOF
%defattr(-, root, root)
%docdir ${RPM_DOC_DIR}/%{name}-%{ver}
%config %{gsr}/share/config.site
%config %{gsr}/Makefiles/GSARCH/GSOS/config.make
%config %{gsr}/Libraries/Resources/NSTimeZones/localtime
%ifos Linux
%attr (0755, root, root) %config /etc/profile.d/GNUstep.csh
%attr (0755, root, root) %config /etc/profile.d/GNUstep.sh
%attr (0755, root, root) %config /etc/rc.d/init.d/gnustep
%endif

%dir %{gsr}
%dir %{gsr}/Apps
%dir %{gsr}/Headers
%dir %{gsr}/Headers/gnustep
%dir %{gsr}/Libraries
%dir %{gsr}/Libraries/Resources
%dir %{gsr}/Libraries/Resources
%dir %{gsr}/Libraries/Resources/NSTimeZones
%dir %{gsr}/Libraries/GSARCH
%dir %{gsr}/Libraries/GSARCH/GSOS
%dir %{gsr}/Local
%dir %{gsr}/Makefiles
%dir %{gsr}/Makefiles/GSARCH
%dir %{gsr}/Makefiles/GSARCH/GSOS
%dir %{gsr}/Tools
%dir %{gsr}/Tools/GSARCH
%dir %{gsr}/Tools/GSARCH/GSOS
%dir %{gsr}/share

${RPM_DOC_DIR}/%{name}-%{ver}

%{gsr}/Headers/gnustep/Foundation
%{gsr}/Headers/gnustep/base
%{gsr}/Headers/gnustep/gui
%{gsr}/Headers/gnustep/unicode
%{gsr}/Headers/gnustep/xgps
%{gsr}/Headers/GSARCH

%{gsr}/Libraries/Resources/Images
%{gsr}/Libraries/Resources/NSCharacterSets
%{gsr}/Libraries/Resources/NSTimeZones/README
%{gsr}/Libraries/Resources/NSTimeZones/abbreviations
%{gsr}/Libraries/Resources/NSTimeZones/*.m
%{gsr}/Libraries/Resources/NSTimeZones/regions
%{gsr}/Libraries/Resources/NSTimeZones/zones
%{gsr}/Libraries/GSARCH/GSOS/gnu-gnu-gnu-xgps
%{gsr}/Library

%{gsr}/Makefiles/*.func
%{gsr}/Makefiles/*.make
%{gsr}/Makefiles/*.csh
%{gsr}/Makefiles/*.sh
%{gsr}/Makefiles/config*
%{gsr}/Makefiles/install-sh
%{gsr}/Makefiles/mkinstalldirs
%{gsr}/Makefiles/GSARCH/GSOS/which_lib

%{gsr}/Tools/debugapp
%{gsr}/Tools/openapp
%{gsr}/Tools/opentool
%attr(05755, root, root) %{gsr}/Tools/GSARCH/GSOS/gdomap
%{gsr}/Tools/GSARCH/GSOS/gnu-gnu-gnu-xgps

EOF

for i in filelist.rpm; do
    cat ${i}.in | sed "s|GSARCH|$tmp5|" | sed "s|GSOS|$tmp7|" > $i
done

%post
if [ -z "$GNUSTEP_SYSTEM_ROOT" ]; then
   . %{gsr}/Makefiles/GNUstep.sh 
fi
grep -q '^gdomap' /etc/services || (echo "gdomap 538/tcp # GNUstep distrib objects" >> /etc/services && echo "gdomap 538/udp # GNUstep distrib objects" >> /etc/services)
echo 'GMT' > %{gsr}/Libraries/Resources/NSTimeZones/localtime

%ifos Linux
/sbin/chkconfig --add gnustep

grep -q '%{gsr}/Libraries/$GNUSTEP_HOST_CPU/$GNUSTEP_HOST_OS/gnu-gnu-gnu-xgps' /etc/ld.so.conf || echo "%{gsr}/Libraries/$GNUSTEP_HOST_CPU/$GNUSTEP_HOST_OS/gnu-gnu-gnu-xgps" >> /etc/ld.so.conf
/sbin/ldconfig
%endif


%ifos Linux
%preun
if [ -z "$GNUSTEP_SYSTEM_ROOT" ]; then
   . %{gsr}/Makefiles/GNUstep.sh 
fi
if [ $1 = 0 ]; then
    /sbin/chkconfig --del gnustep
fi
%endif

%postun
if [ $1 = 0 ]; then
    mv -f /etc/services /etc/services.orig
    grep -v "^gdomap 538" /etc/services.orig > /etc/services
    rm -f /etc/services.orig

%ifos Linux
    mv -f /etc/ld.so.conf /etc/ld.so.conf.orig
    grep -v "^%{gsr}/Libraries/$GNUSTEP_HOST_CPU/$GNUSTEP_HOST_OS/gnu-gnu-gnu-xgps$" /etc/ld.so.conf.orig > /etc/ld.so.conf
    rm -f /etc/ld.so.conf.orig
    /sbin/ldconfig
%endif
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files -f filelist.rpm

%changelog
* Tue Sep 07 1999 Adam Fedor <fedor@gnu.org>
- Version 0.6.0 released.
- New Testing directory.
- New location for NSCharacterSet and NSTimeZone

* Tue Jun 08 1999 Adam Fedor <fedor@gnu.org>
- Use xgps bakend instead of xraw

* Fri Mar 12 1999 Christopher Seawood <cls@seawood.org>
- Version 0.5.5 released
- Removed dependency on dgs
- Removed merged patches

* Tue Mar 02 1999 Christopher Seawood <cls@seawood.org>
- Updated cvs snapshot

* Fri Feb 26 1999 Christopher Seawood <cls@seawood.org>
- Added cflags patch
- Added services patch
- Updated to 0.5.5 (dawn) cvs branch

* Fri Feb 05 1999 Christopher Seawood <cls@seawood.org>
- Added Prereq & Provides
- Built optimized with RPM_OPT_FLAGS rather than -g

* Thu Feb 04 1999 Christopher Seawood <cls@seawood.org>
- Updated cvs snapshot to 990203
- Removed extensions from rpm as they've been removed from src package
- Added gdomap entries to /etc/services as required
- Added init scripts & chkconfig

* Sun Dec 27 1998 Christopher Seawood <cls@seawood.org>
- Updated cvs snapshot on 19981213
- Removed xdrshdr & openapp patches
- Added debugapp patch
- Removed gnustep-xdps sections

* Sun Dec 13 1998 Christopher Seawood <cls@seawood.org>
- Updated cvs snapshot on 19981213
- Added xdrshdr patch
- Added openapp patch

* Mon Dec 07 1998 Christopher Seawood <cls@seawood.org>
- Upgraded cvs snapsnot on 19981206

* Fri Nov 20 1998 Christopher Seawood <cls@seawood.org>
- Upgraded to 981120

* Wed Nov 04 1998 Christopher Seawood <cls@seawood.org>
- Added gnustep-xdps package to spec

* Tue Nov 03 1998 Christopher Seawood <cls@seawood.org>
- Grabbed snapshot from GNUstep CVS tree
- Used xraw backend instead of xdps
- Added RHCN tags

