/* 
   XRDrawingEngine.h

   Functions for performing Xlib based drawing in XRAW.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998

   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_XRDrawingEngine
#define _GNUstep_H_XRDrawingEngine

#include <Foundation/NSGeometry.h>

@class XRWindow;
@class XRView;
@class XRColor;
@class NSView;
@class NSColor;
@class XRFont;

//
// Initialization functions 
//
void XRInitializeDrawingEngine(void);

//
// Miscellaneous functions 
//
void XRCacheSystemImages(void);
int XRUniqueWindowTag(void);

//
// String Functions 
//
void XRDrawString(const char *str, NSRect rect);      
void PSshow(const char *str);   							// simulate PSshow
void XRSetCurrentFont(XRFont *aFont);
   
//
// Color Functions 
//
void XRSetCurrentColor(NSColor *aColor);
void XRSyncFocusWindowColor(NSColor *color, XRWindow *window);
XRColor * XRLightGray(void);		
XRColor * XRBlack(void);
XRColor * XRWhite(void);
XRColor * XRDarkGray(void);

//
// Graphics state control 
//
void XRFocusLock(XRView *view, XRWindow *window);			
void XRSetCanvasSize(NSSize aPoint);
void XRSetCanvasOrigin(NSPoint aPoint);
NSRect XRCanvasRect(void);
void XRSetFlipped(void);
void PSgrestore(void);
void PSgsave(void);

//
// Clipping Functions 
//
void NSRectClip(NSRect aRect);           
void NSRectClipList(const NSRect *rects, int count);
void XRSetClipRect(NSRect aRect);  // aRect in curr window's Openstep coords
void XRRemoveClipPath(void);

//
// Rectangle Drawing Functions 
//
void NSEraseRect(NSRect aRect);          					// Fill with white
void NSHighlightRect(NSRect aRect);      					// draw using XOR 
void NSRectFill(NSRect aRect);           			// Fill with current color
void NSRectFillList(const NSRect *rects, int count);
void NSRectFillListWithGrays(const NSRect *rects,const float *grays,int count);

//
// Draw Bordered Rectangle 
//
void NSDrawButton(NSRect aRect, NSRect clipRect);    		// Button
void NSDrawGrayBezel(NSRect aRect, NSRect clipRect); 		// pushed-in button    
void NSDrawGroove(NSRect aRect, NSRect clipRect);    		// grooved Box          
void NSDrawWhiteBezel(NSRect aRect, NSRect clipRect); 		// like a TextField   
void NSFrameRect(NSRect aRect); 							// 1 pixel line box
void NSFrameRectWithWidth(NSRect aRect, float frameWidth);

//
// Postscript emulation Functions
//
void PSlineto(float x, float y);
void PSmoveto(float x, float y);
void PSrlineto(float x, float y);

void PSstroke(void);										// dummy functions
void PSnewpath(void);										// defined but not 
void PSclosepath(void);										// implemented in
void PSfill(void);											// XRAW
void PSsetlinewidth(float width);			
void PSsetgray(float num);					

#endif /* _GNUstep_H_XRDrawingEngine */
