/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VrINTERPOLATINGSIGPROC_H_
#define _VrINTERPOLATINGSIGPROC_H_

#include <VrHistoryProc.h>

template<class iType, class oType> 
class VrInterpolatingSigProc : public VrHistoryProc<iType,oType> {

protected:
  int 	interp;

public: 
  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);

  virtual void pre_initialize ();

  VrInterpolatingSigProc() : interp(1) {}

  VrInterpolatingSigProc(int outputs) :
    VrHistoryProc<iType, oType>(outputs),
    interp(1) {}

  VrInterpolatingSigProc(int outputs, int i) :
    VrHistoryProc<iType, oType>(outputs),
    interp(i) {}

  virtual ~VrInterpolatingSigProc() {}

  virtual int work(VrSampleRange output, void *ao[], VrSampleRange inputs[], void *ai[]);

};

template<class iType,class oType> int
VrInterpolatingSigProc<iType,oType>::forecast(VrSampleRange output,
					      VrSampleRange inputs[]) {
  /* 1:interp ratio */
  /*
   * Note that this code only works correctly if output size of the
   * module (set using setOutputSize(n) in initialize() ) is a multiple
   * of interp.
   */
  assert ((output.size % interp) == 0);
  
  for(unsigned int i=0;i<numberInputs;i++) {
    inputs[i].index=output.index/interp; /* ! do not subtract history ! */
    inputs[i].size=output.size/interp + history-1;
  }
  return 0;
}  


template<class iType,class oType> void 
VrInterpolatingSigProc<iType,oType>::pre_initialize ()
{
  assert (interp >= 1);
  if (interp == 1){
    fprintf (stderr, "### Warning: interp == 1 in pre_initialize of %s.  Are you sure?\n",
	     name ());
  }
  if (getSamplingFrequency () == 0.0)
    setSamplingFrequency (getInputSamplingFrequencyN (0) * interp);

  setOutputSize(interp);
}

template<class iType,class oType> int
VrInterpolatingSigProc<iType,oType>::work(VrSampleRange output, void *ao[],
					  VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;
  iType input_symbol; 

  for (int insamp = 0; insamp < size/interp; insamp++){
    input_symbol = i[0][insamp];
    *o[0]++ = input_symbol;
    for (int outsamp = 1; outsamp < interp; outsamp++){
      *o[0]++ = 0;
    }
  }
  return output.size;
}

#endif
