/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

/*
 * This program demodulates the FSK control channel for an AMPS
 * cellular telephone.  The demodulated data is written to a file
 * for further off-line processing.
 */

/* --Definition--
 *  
 * 1. cTaps:  number of taps in the complex filter. It determines the Q of the filter.
 *            Q is the ratio of  (the width of the passband) / (the center frequency)
 *
 * 2. gupRate: The sample rate of the GuPPI. Fixed by the crystal in the GuPPI
 *
 * 3. CFIRdecimate: The ratio of (input sample rate) / (output sample rate)
 *
 *    The actual ratio is   GuPPI_rate / Amps_rate  =  33000000 / 8000 = 825 * 4
 *
 * 4. quadRate: data rate of the output of the Complex FIR filter
 *
 *



   5. CONNECT:connects the processing module together. 
       
         CONNECT(output module, input_module, sample rate, sample size in bits)
 
   6. sink->start():  initialize modules actually connected to the sink

   7. guimain->start(): initialize the screen interface module

   8. guimain->processEvents: process events from the GUI

   9. sink->process(): process "some input samples"

  10. VrGuppiSource: GuPPI source
  11. VrComplexFIRfilter: Channel filter which select out one channel from the digitized data, and translate it to baseband  
  12. VrFSKamps: looks at sample  in that channel and extract binary data.
  13. VrFileSink: write binary data to a file "tmp.dat"

 */

#include <VrGuppiSource.h>
#include <VrComplexFIRfilter.h>
#include <VrFSKamps.h>
#include <VrFileSink.h>
#include <VrSigSource.h>
#include <VrConnect.h>
// #include "VrGUI.h"

int main(int argc, char **argv)
{
  int gupRate;
  int CFIRdecimate;
  int quadRate;
  int RFIRdecimate;
  int outputDataRate;
  int cTaps;
  
  int count=0;

  // VrGUI *guimain = new VrGUI(argc, argv);


  cTaps = 200;
  gupRate = 33000000;                        
  CFIRdecimate = 550;
  quadRate = gupRate / CFIRdecimate;
  RFIRdecimate = 1; 
  outputDataRate = quadRate / RFIRdecimate; 

  cerr << "GuPPI Sampling Rate: " << gupRate << endl;
  cerr << "Complex FIR decimation factor: " << CFIRdecimate << endl;
  cerr << "QuadDemod Sampling Rate: " << quadRate << endl;
  cerr << "Real FIR decimation factor: " << RFIRdecimate << endl;


  float chanfreq = 10.7e6; 
  VrGuppiSource<char>* source = new VrGuppiSource<char>(); 
  VrComplexFIRfilter<char>* proc = 
    new VrComplexFIRfilter<char>(CFIRdecimate,cTaps, chanfreq,1.0);
  VrFSKamps<VrComplex>* demod = new VrFSKamps<VrComplex>(10000); 
  VrFileSink<char>* sink = new VrFileSink<char>("tmp.dat"); 

    
  //connect the modules together  
  CONNECT(sink, demod, outputDataRate, 8);
  CONNECT(demod, proc, quadRate, 64);
  CONNECT(proc, source, gupRate, 8);

  sink->start(); 
  //guimain->start(); 

printf ("start\n");

  while (count < 700) {
    //guimain->processEvents(10 /*ms*/);
    sink->process();  
    count += 1;
  }  
  cerr << "\nFinish taking " << count << " set of samples.\n";
  cerr << "Start converting data\n";
}












