/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/gnunet-setup-hostlist-editing.c
 * @brief allow editing of the hostlist
 * @author Christian Grothoff
 */
#include "gnunet-setup.h"

/**
 * Handle editing of text in the GtkListModel.  Changes
 * the new entry to non-editable and creates another
 * empty entry at the end.
 *
 * @param renderer renderer emitting the signal
 * @param path path identifying the edited cell
 * @param new_text text that was added
 * @param user_data not used
 */
void
GNUNET_setup_hostlist_url_cellrenderertext_edited_cb (GtkCellRendererText *renderer,
						      gchar *path,
						      gchar *new_text,
						      gpointer user_data)
{
  GtkListStore *ls;
  GtkTreeIter old;
  GtkTreeIter iter;

  ls = GTK_LIST_STORE (gtk_builder_get_object (builder, 
					       "GNUNET_setup_hostlist_url_liststore"));
  if (ls == NULL)
    {
      GNUNET_break (0);
      return;
    }
  if (TRUE != 
      gtk_tree_model_get_iter_from_string (GTK_TREE_MODEL (ls),
					   &old,
					   path))
    {
      GNUNET_break (0);
      return;
    }
  
  gtk_list_store_insert_before (ls, &iter, &old);
  gtk_list_store_set (ls,
		      &iter,
		      0, new_text,
		      1, FALSE,
		      -1);
}

/* end of gnunet-setup-hostlist-editing.c */
