/*
     This file is part of GNUnet
     (C) 2001, 2002, 2003, 2004, 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * @file include/gnunet_session_service.h
 * @brief Code that maintains the GNUnet session.
 *  It is responsible for establishing connections.
 * @author Christian Grothoff
 */

#ifndef GNUNET_SESSION_SERVICE_H
#define GNUNET_SESSION_SERVICE_H

#include "gnunet_util.h"

#ifdef __cplusplus
extern "C"
{
#if 0                           /* keep Emacsens' auto-indent happy */
}
#endif
#endif

/**
 * @brief session service API
 *
 * Session is responsible for establishing a session with another
 * peer (SKEY exchange).
 */
typedef struct
{

  /**
   * Try to connect to the given peer.
   *
   * @return GNUNET_SYSERR if that is impossible,
   *         GNUNET_YES if a connection is established upon return,
   *         GNUNET_NO if we're going to try to establish one asynchronously
   */
  int (*tryConnect) (const GNUNET_PeerIdentity * peer);

} GNUNET_Session_ServiceAPI;

#if 0                           /* keep Emacsens' auto-indent happy */
{
#endif
#ifdef __cplusplus
}
#endif

#endif
/* end of gnunet_session_service.h */
