#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.definitions.GObjects import *
from gnue.common.apps import GDebug
from gnue.common.datasources import GConditions
from gnue.common.logic.GTrigger import GTrigger,GTriggerExtension
import string
from xml.sax import saxutils
from GRLayoutElement import GRLayoutElement
from gnue.reports.base.GRParameters import GRStubParam

############################################################
#
# Parameters
#
class GRParam(GRLayoutElement, GRStubParam):
  _typestub = 'GRParam'

  def __init__(self, parent):
    # This is passed parent=None so that
    # the GObj.__init__ doesn't add this
    # object twice to its parent (icky)
    GRLayoutElement.__init__(self, parent=None)
    GRStubParam.__init__(self, parent)

  def process(self, dest, mapper, isfirst, islast, firstSection, nextSection):
    ## structuralComment(dest,"<!-- [param:%s] -->" % self.name)
    dest.write (self.getFormattedValue())
    ## structuralComment(dest,"<!-- [/param:%s] -->" % self.name)
    return nextSection
