# GNU Enterprise Forms - wx 2.6 UI Driver - Toolbar widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: toolbar.py 9956 2009-10-11 18:54:57Z reinhard $

import wx

from gnue.forms.uidrivers.wx26.widgets._base import UIHelper


# =============================================================================
# Wrap an UI layer around a wxMenu widget
# =============================================================================

class UIToolbar(UIHelper):
    """
    Implements a toolbar object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new toolbar widget.
        """

        widget = None

        if self._gfObject.name == '__main_toolbar__' \
                and not self._form._features['GUI:TOOLBAR:SUPPRESS']:

            # Make sure to disable the color-remapping in windows
            wx.SystemOptions.SetOption ('msw.remap', '0')

            # Toolbar of the form
            if isinstance(self._uiForm.main_window, wx.Frame):
                widget = self._uiForm.main_window.CreateToolBar()
                widget.SetToolBitmapSize((24, 24))

        self._container = widget

        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIToolbar,
  'provides' : 'GFToolbar',
  'container': 1,
}
