# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: entry.py 9956 2009-10-11 18:54:57Z reinhard $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32gui
import win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Entry
from gnue.forms.uidrivers.win32.common import *

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
    def _create_widget(self, event, spacer):
        object = event.object

        ostyle = object.style
        height = self.itemHeight
        width = self.itemWidth
        title = ""

        if ostyle == 'dropdown':
            #~ style = win32con.WS_CHILD | win32con.WS_VSCROLL | win32con.LBS_NOTIFY | \
                     #~ win32con.CBS_DROPDOWNLIST | win32con.CBS_NOINTEGRALHEIGHT
            style = win32con.WS_CHILD | win32con.WS_VSCROLL | \
                       win32con.CBS_DROPDOWN | win32con.CBS_NOINTEGRALHEIGHT
            styleEx = 0
            className = "COMBOBOX"
            height = self.itemHeight +100 # TODO
      
        elif ostyle == 'listbox':
            style = win32con.WS_CHILD | win32con.WS_VSCROLL | win32con.LBS_NOTIFY
            styleEx = win32con.WS_EX_CLIENTEDGE
            className = "LISTBOX"

        elif ostyle == 'label':
            style = win32con.WS_CHILD
            styleEx = 0
            className = "STATIC"

        elif ostyle == 'checkbox':
            style = win32con.WS_CHILD | win32con.BS_AUTOCHECKBOX
            styleEx = 0
            className = "BUTTON"
            title = object.label

        else: # Normal text box
            height = self.itemHeight + 2
            width = self.itemWidth
            style = win32con.WS_CHILD #| win32con.WS_BORDER

            if hasattr(object,'Char__height') and object.Char__height > 1:
                style = style | win32con.ES_MULTILINE | win32con.ES_AUTOVSCROLL | \
                        win32con.WS_VSCROLL #| win32con.ES_WANTRETURN
                width = self.itemWidth
            else:
                style = style | win32con.ES_AUTOHSCROLL

            if object.style == 'password':
                style = style | win32con.ES_PASSWORD

            styleEx = win32con.WS_EX_CLIENTEDGE
            className = "EDIT"

        newWidget = Win32Entry(self._uiDriver, styleEx, className, title, style,
                            self.itemX,
                            self.itemY,
                            width,
                            height,
                            event.container, getNextId())

        return newWidget


    # ---------------------------------------------------------------------------
    # Enable/disable this entry
    # ---------------------------------------------------------------------------

    def _ui_enable_(self, index):
        self.widgets[index].Enable(True)

    # ---------------------------------------------------------------------------

    def _ui_disable_(self, index):
        self.widgets[index].Enable(False)


    # -------------------------------------------------------------------------
    # Set "editable" status for this widget
    # -------------------------------------------------------------------------

    def _ui_set_editable_(self, index, editable):

        # TODO: grey out entry, disallow changes if possible.
        pass


    # ---------------------------------------------------------------------------
    # Clipboard and selection
    # ---------------------------------------------------------------------------

    def _ui_cut_(self, index):
  
        widget = self.widgets[index]

        if hasattr(widget, 'Cut'):
            widget.Cut()

    # ---------------------------------------------------------------------------

    def _ui_copy_(self, index):
  
        widget = self.widgets[index]
    
        if hasattr(widget, 'Copy'):
            widget.Copy()

    # ---------------------------------------------------------------------------

    def _ui_paste_(self, index):
  
        widget = self.widgets[index]

        if hasattr(widget, 'Paste'):
            widget.Paste()

    # ---------------------------------------------------------------------------

    def _ui_select_all_(self, index):
  
        widget = self.widgets[index]

        if hasattr(widget, 'SelectAll'):
            widget.SelectAll()

    # ---------------------------------------------------------------------------

    def _ui_set_choices_(self, index, choices):

        widget = self.widgets[index]

        if self._gfObject.style == 'dropdown':
            RESETCONTENT = win32con.CB_RESETCONTENT
            ADDSTRING = win32con.CB_ADDSTRING
        else:
            RESETCONTENT = win32con.LB_RESETCONTENT
            ADDSTRING = win32con.LB_ADDSTRING

        win32gui.SendMessage(widget.GetHwnd(), RESETCONTENT, 0, 0)
        self._choices = []
        for item in choices:
            win32gui.SendMessage(widget.GetHwnd(), ADDSTRING, 0, textEncode(item))
            self._choices.append(textEncode(item))


configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
