#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# gtk2/GFApp.py
#
# DESCRIPTION:
# A gtk2 based user interface driver for GNUe forms.
# Application frameword
#
# NOTES:
#
import pygtk
pygtk.require('2.0')

import gtk
from gnue.common.apps import GDebug

__gtk2App = None

def getApp():
    global __gtk2App

    if not __gtk2App:
        __gtk2App = GFgtk2App()
    return __gtk2App

class GFgtk2App:
    _mainLoop= None
    _use_count = 0
    
    def __init__(self):
        assert gDebug(6,"GFgtk2App initializing")

    def mainLoop (self):
        self._use_count += 1            
        assert gDebug(6,"GFgtk2App starting loop (no. %s)" % self._use_count)
        if self._mainLoop == None:
            self._mainLoop = 1
            gtk.main()

    def quit (self):
        assert gDebug(6,"GFgtk2App stopping loop (no. %s)" % self._use_count)
        self._use_count -= 1
        if self._use_count <= 0:
            assert gDebug(6,"GFgtk2App closing down")
            gtk.main_quit()

    def openLoops (self):
        return self._use_count
