/* xfrom.c -- In conjunction with GNU From, a useful X tool. */

#include <string.h>
#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

#include "general.h"
#include "unixmail.h"

extern struct passwd *getpwuid ();

#define FONT "fixed"

/* The name of the program as taken from argv[0]. */
char *progname;

/* Font globals. */
int dir, ascent, descent;
XCharStruct overall;

#define VERT_MARGIN 6
#define HORZ_MARGIN 4

Display *dpy;
int screen;
int fg, bg;
GC gc;

main (argc, argv)
     int argc;
     char **argv;
{
  Window win, root;
  XFontStruct *font;
  int win_width, win_height;
  char *arg, *usermail;
  long atime, mtime;

  arg = (char *)rindex (argv[0], '/');

  if (arg && arg != argv[0])
    progname = arg + 1;
  else
    progname = argv[0];

  /* Create the filename for the current spool file. */
  {
    struct passwd *entry;

    entry = getpwuid (getuid ());

    if (!entry)
      {
	fprintf (stderr, "%s: You have no username!\n", progname);
	exit (1);
      }

    usermail = (char *)
      xmalloc (3 + strlen (entry->pw_name) + strlen (SPOOLDIR));

    sprintf (usermail, "%s/%s", SPOOLDIR, entry->pw_name);
  }

  /* Make sure that the current read and mod times are earlier than
     the current so that we at least read the file once. */
  atime = mtime = 0;

  dpy = XOpenDisplay ((char *)NULL);
  screen = DefaultScreen (dpy);
  root = RootWindow (dpy, screen);
  gc = DefaultGC (dpy, screen);

  bg = WhitePixel (dpy, screen);
  fg = BlackPixel (dpy, screen);

  font = XLoadQueryFont (dpy, FONT);
  XSetFont (dpy, gc, font->fid);
  XTextExtents (font, "M", 1, &dir, &ascent, &descent, &overall);

  /* Window is 80 characters wide, and 10 lines tall. */
  win_width = (80 * overall.width) + (HORZ_MARGIN * 2);
  win_height = (10 * (overall.ascent + overall.descent)) + (VERT_MARGIN * 2);

  win =
    XCreateSimpleWindow (dpy, root, 0, 0, win_width, win_height, 2, fg, bg);

  XSetStandardProperties (dpy, win, progname, progname, None, argv, argc, 0);
  XSelectInput (dpy, win, ExposureMask);
  XMapWindow (dpy, win);

  while (1)
    {
      static char **from_array = (char **)NULL;
      long local_mtime;
      struct stat finfo;
      XEvent event;

      XNextEvent (dpy, &event);

      if (stat (usermail, &finfo) != -1)
	local_mtime = finfo.st_mtime;
      else
	local_mtime = 0;
	  
      if (local_mtime != mtime)
	{
	  mtime = finfo.st_mtime;

	  if (from_array)
	    {
	      free_array (from_array);
	      from_array = (char **)NULL;
	    }
	  from_array =
	    from_headers
	      (usermail, (char *)NULL, (char *)NULL, (char *)NULL, 0);
	}

      if (!from_array)
	{
	  char *temp[2];
	  char line[1024];

	  sprintf (line, "No mail in %s", usermail);
	  temp[0] = line;
	  temp[1] = (char *)NULL;

	  refresh_win (win, font, temp);
	}
      else
	refresh_win (win, font, from_array);
    }
}

/* Release the memory allocated to the array of char *. */
free_array (array)
     char **array;
{
  register int i;

  for (i = 0; array && array[i]; i++)
    free (array[i]);

  if (array)
    free (array);
}

refresh_win (win, font, array)
     Window win;
     XFontStruct *font;
     char **array;
{
  register int i, y;
  int line_spacing = 4;
  char *line;
  XWindowAttributes attrib;

  XGetWindowAttributes (dpy, win, &attrib);
  XSetFunction (dpy, gc, GXclear);
  XFillRectangle (dpy, win, gc, 0, 0, attrib.width, attrib.height);
  XSetFunction (dpy, gc, GXcopy);

  if (array)
    {
      for (i = 0, y = VERT_MARGIN; line = array[i]; i++)
	{
	  y += overall.ascent;
	  XDrawString (dpy, win, gc, HORZ_MARGIN, y, line, strlen (line));
	  y += overall.descent + line_spacing;
	}
    }
}

