package gnats;

$tkgnatslib = '/usr/local/lib/tkgnats';
#$tkgnatslib = '.';

$init_sw = 1;

@sql = (
    'id_number', 'catagory', 'synopsis', 'confidential',
    'severity', 'priority', 'responsible', 'state', 'class',
    'submitter_id', 'arrival_date', 'originator', 'release'
);

@severity = ( 'critical', 'serious', 'non-critical' );
@priority = ( 'high', 'medium', 'low' );
@state = ( 'open', 'analyzed', 'suspended', 'feedback', 'closed' );
@class = ( 'sw-bug', 'doc-bug', 'change-request', 'support' );

&init;

sub init {
    if ($init_sw) {
	$GnatsHome = (getpwnam(gnats))[7];
	$init_sw = 0;
    }
}

sub parse_full {
    local(*rec, $id) = @_;
    local($cmd, $tmp, $key, $ret);

    if ($id =~ m,^/,) {
	if (! open(TMP, '<' . $id)) {
	    warn "Could not open [$id] for reading:  $!\n";
	    return(0);
	}
    } else {
	$cmd = "query-pr --full $id";
	if (! open(TMP, $cmd . '|')) {
	    warn "Could not spawn [$cmd] for reading:  $!\n";
	    return(0);
	}
    }
    $key = undef;
    # Mail tags.
    while (<TMP>) {
	if (m/^([A-Z][^:]*):\s*/) {
	    if (defined($key)) {
		$rec{$key} = $dat;
	    }
	    $key = $1;
	    $dat = $';
	} elsif (length == 1) {
	    # GNATS tags.
	    while (<TMP>) {
		if (m/^(>Unformatted):\s*/) {
		    if (defined($key)) {
			$rec{$key} = $dat;
		    }
		    $key = $1;
		    $dat = $';
		    while (<TMP>) {
			$dat .= $_;
		    }
		    $rec{$key} = $dat;
		    last;
		} elsif (m/^(>[^:]+):\s*/) {
		    # GNATS tag.
		    if (defined($key)) {
			$rec{$key} = $dat;
		    }
		    $key = $1;
		    $dat = $';
		} else {
		    $dat .= $_;
		}
	    }
	    last;
	} else {
	    $dat .= $_;
	}
    }
    if (defined($key)) {
	$rec{$key} = $dat;
	$ret = 1;
    } else {
	$ret = 0;
    }
    close(TMP);
    $ret;
}

sub file2id {
    local(@file) = @_;
    local(@id, $t, $x);

    $#id = $#file;
    for ($x = 0; $x < scalar(@file); ++$x) {
	$t = $file[$x];
	$t =~ s,^.*/([^/]*)$,$1,;
	$id[$x] = $t;
    }
    if ((! wantarray) && (scalar(@file) == 1)) {
	$id[0];
    } else {
	@id;
    }
}

sub list {
    local($cmd);
    local(@ret);

    $cmd = 'query-pr --sql';
    if (! open(TMP, $cmd . '|')) {
	warn "Cannot spawn [$cmd] for reading:  $!\n";
	return(0);
    }
    while (<TMP>) {
	chop;
	s/\s*\|\s*/\|/g;
	$ret[++$#ret] = $_;
    }
    close(TMP);
    @ret;
}

sub filter_dialog {
    local($cmd, *ret) = @_;
    local($sw, $pid);

    $pid = open(TMP, $cmd . '|');
    return("Cannot spawn [$cmd] for reading:  $!\n") unless ($pid);

    $sw = 0;
    while (<TMP>) {
	chop;
	m/^([^=]*)=(.*)$/;
	$ret{$1} = $2;
	++$sw;
    }
    close(TMP);
    waitpid($pid, 0);

    if ($sw) {
	"execute";
    } else {
	"cancel";
    }
}

sub filter_init {
    local($tkgnatslib, *usage) = @_;
    local($cmd, %params);

    package main;

    $opt_o = 'ps'; # Valid:  otroff, nroff, or whatever is known by groff
    $opt_f = undef;
    $opt_p = undef;
     
    &usage unless (&Getopts("f:o:p:P"));
     
    if (! (defined($opt_f) || defined($opt_p))) {
	$cmd = join('/', $tkgnatslib, "output_dialog.t");
	&gnats'filter_dialog($cmd, *params);
	$opt_o = $params{'Format'};
	$tmp = $params{'Type'};
	if ($tmp eq 'Printer') {
	    $opt_f = undef;
	    $opt_p = $params{'Entry'};
	} else {
	    $opt_f = $params{'Entry'};
	    $opt_p = undef;
	}
	$opt_P = $params{'Preview'};
    }
}

1;
