// 
//   Copyright (C) 2005, 2006, 2007 Free Software Foundation, Inc.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

// 
//
#ifndef __RC_H__
#define __RC_H__

// This is generated by autoconf
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "tu_config.h"

#include <string>
#include <vector>

namespace gnash {
  
class DSOEXPORT RcInitFile 
{
public:
    RcInitFile();
    ~RcInitFile();

    // Return the default instance of RC file,
    static RcInitFile& getDefaultInstance();

    bool loadFiles();

    bool parseFile(const std::string& filespec);
    bool updateFile(const std::string& filespec);
    
    bool useSplashScreen() const { return _splash_screen; }
    void useSplashScreen(bool value);

    bool useActionDump() const { return _actiondump; }
    void useActionDump(bool value);

    bool useParserDump() const { return _parserdump; }
    void useParserDump(bool value);

    bool useWriteLog() const { return _writelog; }
    void useWriteLog(bool value);

    int getTimerDelay() const { return _delay; }
    void setTimerDelay(int x) { _delay = x; }

    bool showASCodingErrors() const { return _verboseASCodingErrors; }
    void showASCodingErrors(bool value);

    bool showMalformedSWFErrors() const { return _verboseMalformedSWF; }
    void showMalformedSWFErrors(bool value);

    bool enableExtensions() const { return _extensionsEnabled; }

    /// Return true if user is willing to start the gui in "stop" mode
    //
    /// defaults to false.
    ///
    bool startStopped() const { return _startStopped; }
    
    int verbosityLevel() const { return _verbosity; }
    void verbosityLevel(int value) { _verbosity = value; }
    
    std::string getDebugLog() const { return _log; }
    std::string getDocumentRoot() { return _wwwroot; }
    
    bool useDebugger() const { return _debugger; }
    void useDebugger(bool value) { _debugger = value; }

    bool useSound() const { return _sound; }
    void useSound(bool value) { _sound = value; }

    // strk: I'd drop this, and allow an -f switch to select
    //       the gnashrc file to use instead
    bool usePluginSound() const { return _plugin_sound; }
    void usePluginSound(bool value) { _plugin_sound = value; }

    bool useLocalDomain() const { return _localdomain_only; }
    void useLocalDomain(bool value);
    
    bool useLocalHost() const { return _localhost_only; }
    void useLocalHost(bool value);

    static bool extractSetting(bool *var, const char *pattern, std::string &variable,
                        std::string &value);
    
    static int extractNumber(int *num, const char *pattern, std::string &variable,
                        std::string &value);
    
    const std::vector<std::string>& getWhiteList() const { return _whitelist; }
    const std::vector<std::string>& getBlackList() const { return _blacklist; }

    int getRetries() const { return _retries; }
    void setRetries(int x) { _retries = x; }

    void dump();
    
private:

    int  _delay;                // the timer delay
    bool _debug;                // enable debugging of this class
    bool _debugger;             // enable the Flash movie debugger
    int  _verbosity;
    bool _actiondump;           // enable dumping actionscript classes
    bool _parserdump;           // enable dumping parser data

    /// Enable ActionScript errors verbosity
    bool _verboseASCodingErrors;

    /// Enable Malformed SWF verbosity
    bool _verboseMalformedSWF;
    
    
    // End user Features
    bool _splash_screen;        // display a splash screen when
                                // loading a movie
    // Security Features
    bool _localdomain_only;     // only access network resources for
                                // the local domain
    bool _localhost_only;       // only access network resources 
    std::vector<std::string> _whitelist; // domains we allow
    std::vector<std::string> _blacklist; // domains we don't allow
    std::string _log;           // the name of the debug log
    bool _writelog;             // enable writing the debug log to disk
    std::string _wwwroot;       // the root path for the streaming server
    int _retries;               // the number of retries for a thread
    bool _sound;		// whether sound is enable or not
    bool _plugin_sound;		// whether sound is desired for the plugin

    bool _extensionsEnabled;	// wheter to scan plugin path for extensions

    bool _startStopped;		// whether to start the gui in "stop" mode
};

//extern DSOEXPORT RcInitFile rcfile;

// End of gnash namespace 
}

// __RC_H__
#endif


// local Variables:
// mode: C++
// indent-tabs-mode: t
// End:
