/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem.linalg;

import gnu.gleem.linalg.Vecf;

public class Vec4f {
    private float x;
    private float y;
    private float z;
    private float w;

    public Vec4f() {
    }

    public Vec4f(Vec4f arg) {
        this.set(arg);
    }

    public Vec4f(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Vec4f copy() {
        return new Vec4f(this);
    }

    public void set(Vec4f arg) {
        this.set(arg.x, arg.y, arg.z, arg.w);
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void set(int i, float val) {
        switch (i) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            case 2: {
                this.z = val;
                break;
            }
            case 3: {
                this.w = val;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public float dot(Vec4f arg) {
        return this.x * arg.x + this.y * arg.y + this.z * arg.z + this.w * arg.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.scale(1.0f / len);
    }

    public Vec4f times(float val) {
        Vec4f tmp = new Vec4f(this);
        tmp.scale(val);
        return tmp;
    }

    public void scale(float val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
        this.w *= val;
    }

    public Vec4f plus(Vec4f arg) {
        Vec4f tmp = new Vec4f();
        tmp.add(this, arg);
        return tmp;
    }

    public void add(Vec4f b) {
        this.add(this, b);
    }

    public void add(Vec4f a, Vec4f b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
        this.w = a.w + b.w;
    }

    public Vec4f addScaled(float s, Vec4f arg) {
        Vec4f tmp = new Vec4f();
        tmp.addScaled(this, s, arg);
        return tmp;
    }

    public void addScaled(Vec4f a, float s, Vec4f b) {
        this.x = a.x + s * b.x;
        this.y = a.y + s * b.y;
        this.z = a.z + s * b.z;
        this.w = a.w + s * b.w;
    }

    public Vec4f minus(Vec4f arg) {
        Vec4f tmp = new Vec4f();
        tmp.sub(this, arg);
        return tmp;
    }

    public void sub(Vec4f b) {
        this.sub(this, b);
    }

    public void sub(Vec4f a, Vec4f b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
        this.w = a.w - b.w;
    }

    public Vecf toVecf() {
        Vecf out = new Vecf(4);
        int i = 0;
        while (i < 4) {
            out.set(i, this.get(i));
            ++i;
        }
        return out;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

