/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gnu.gleem.Manip;
import gnu.gleem.ManipPart;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.Vec3f;
import java.util.List;

public class ManipPartLineSeg
extends ManipPart {
    private Vec3f color = new Vec3f(0.8f, 0.8f, 0.8f);
    private Vec3f highlightColor = new Vec3f(0.8f, 0.8f, 0.2f);
    private boolean highlighted = false;
    private boolean visible = true;
    private static Vec3f[] vertices = new Vec3f[]{new Vec3f(-1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f)};
    private Mat4f xform = new Mat4f();
    private Vec3f[] curVertices;

    public ManipPartLineSeg() {
        this.xform.makeIdent();
        this.curVertices = null;
    }

    public void setColor(Vec3f color) {
        this.color.set(color);
    }

    public Vec3f getColor() {
        return new Vec3f(this.color);
    }

    public void setHighlightColor(Vec3f highlightColor) {
        this.highlightColor.set(highlightColor);
    }

    public Vec3f getHighlightColor() {
        return new Vec3f(this.highlightColor);
    }

    public void intersectRay(Vec3f rayStart, Vec3f rayDirection, List results, Manip caller) {
    }

    public void setTransform(Mat4f xform) {
        this.xform.set(xform);
        this.recalcVertices();
    }

    public void highlight() {
        this.highlighted = true;
    }

    public void clearHighlight() {
        this.highlighted = false;
    }

    public void setPickable(boolean pickable) {
    }

    public boolean getPickable() {
        return false;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void render(GLFunc gl) {
        if (!this.visible) {
            return;
        }
        boolean reenable = gl.glIsEnabled(2896);
        gl.glDisable(2896);
        gl.glBegin(1);
        if (this.highlighted) {
            gl.glColor3f(this.highlightColor.x(), this.highlightColor.y(), this.highlightColor.z());
        } else {
            gl.glColor3f(this.color.x(), this.color.y(), this.color.z());
        }
        int i = 0;
        while (i < this.curVertices.length) {
            Vec3f v = this.curVertices[i];
            gl.glVertex3f(v.x(), v.y(), v.z());
            ++i;
        }
        gl.glEnd();
        if (reenable) {
            gl.glEnable(2896);
        }
    }

    private void recalcVertices() {
        int i;
        if (this.curVertices == null || this.curVertices.length != vertices.length) {
            this.curVertices = new Vec3f[vertices.length];
            i = 0;
            while (i < vertices.length) {
                this.curVertices[i] = new Vec3f();
                ++i;
            }
        }
        i = 0;
        while (i < this.curVertices.length) {
            this.xform.xformPt(vertices[i], this.curVertices[i]);
            ++i;
        }
    }
}

