/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.util.Iterator;

class ValidationLayers {
    private boolean[] layersValid;

    ValidationLayers(Technology tech) {
        int numLayers = tech.getNumLayers();
        this.layersValid = new boolean[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            this.layersValid[i] = false;
        }
        Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            Technology.NodeLayer[] layers = np.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = layers[i].getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
        it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            Iterator<Layer> lIt = ap.getLayerIterator();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                this.layersValid[layer.getIndex()] = true;
            }
        }
    }
}

