/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableDump
extends LibraryFiles {
    private int textLevel;
    private int bitCount;
    private int curArcEnd;
    private int varPos;
    private Cell curCell;
    private int curCellNumber;
    private int curNodeInstIndex;
    private int curArcInstIndex;
    private int curExportIndex;
    private double[] nodeProtoOffX;
    private double[] nodeProtoOffY;
    private LibraryFiles.NodeInstList[] nodeInstList;
    private ArcInstList[] arcInstList;
    private ExportList[] exportList;
    private int keywordArrayLen;
    private char[] keywordArray = null;
    private String keyWord;
    private Tool[] toolList;
    private Tool curTool;
    private Technology[] techList;
    private Technology curTech;
    private int[] lambdaValues;
    private int curCellGroup;
    private CellName curCellName;
    private int curCellCreationDate;
    private int curCellRevisionDate;
    private Technology curCellTech;
    private int curCellUserbits;
    private int curCellLowX;
    private int curCellHighX;
    private int curCellLowY;
    private int curCellHighY;
    private Cell[] allCellsArray;
    private static final int INLIB = 1;
    private static final int INCELL = 2;
    private static final int INPORTPROTO = 3;
    private static final int INNODEINST = 4;
    private static final int INPOR = 5;
    private static final int INARCINST = 6;
    private static final int INARCEND = 7;
    private static final int INVTOOL = 1;
    private static final int INVTECHNOLOGY = 2;
    private static final int INVLIBRARY = 3;
    private static final int INVNODEPROTO = 4;
    private static final int INVNODEINST = 5;
    private static final int INVPORTPROTO = 6;
    private static final int INVARCINST = 7;

    ReadableDump() {
    }

    @Override
    protected boolean readLib() {
        try {
            return this.readTheLibrary();
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    private boolean readTheLibrary() throws IOException {
        this.lib.erase();
        this.textLevel = 1;
        while (!this.getKeyword()) {
            String thisKey = this.keyWord;
            if (this.getKeyword()) break;
            switch (this.textLevel) {
                case 1: {
                    if (thisKey.equals("****library:")) {
                        this.keywordNewLib();
                        break;
                    }
                    if (thisKey.equals("bits:")) {
                        this.keywordLibBit();
                        break;
                    }
                    if (thisKey.equals("lambda:")) {
                        this.keywordLambda();
                        break;
                    }
                    if (thisKey.equals("version:")) {
                        this.keywordVersn();
                        break;
                    }
                    if (thisKey.equals("aids:")) {
                        this.keywordLibKno();
                        break;
                    }
                    if (thisKey.equals("aidname:")) {
                        this.keywordLibAiN();
                        break;
                    }
                    if (thisKey.equals("aidbits:")) {
                        this.keywordLibAiB();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordLibUsb();
                        break;
                    }
                    if (thisKey.equals("techcount:")) {
                        this.keywordLibTe();
                        break;
                    }
                    if (thisKey.equals("techname:")) {
                        this.keywordLibTeN();
                        break;
                    }
                    if (thisKey.equals("cellcount:")) {
                        this.keywordLibCC();
                        break;
                    }
                    if (thisKey.equals("maincell:")) {
                        this.keywordLibMS();
                        break;
                    }
                    if (thisKey.equals("view:")) {
                        this.keywordLibVie();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 2: {
                    if (thisKey.equals("bits:")) {
                        this.keywordCelBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordCelUsb();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordCelNam();
                        break;
                    }
                    if (thisKey.equals("version:")) {
                        this.keywordCelVer();
                        break;
                    }
                    if (thisKey.equals("creationdate:")) {
                        this.keywordCelCre();
                        break;
                    }
                    if (thisKey.equals("revisiondate:")) {
                        this.keywordCelRev();
                        break;
                    }
                    if (thisKey.equals("externallibrary:")) {
                        this.keywordCelExt();
                        break;
                    }
                    if (thisKey.equals("lowx:")) {
                        this.keywordCelLX();
                        break;
                    }
                    if (thisKey.equals("highx:")) {
                        this.keywordCelHX();
                        break;
                    }
                    if (thisKey.equals("lowy:")) {
                        this.keywordCelLY();
                        break;
                    }
                    if (thisKey.equals("highy:")) {
                        this.keywordCelHY();
                        break;
                    }
                    if (thisKey.equals("nodes:")) {
                        this.keywordCelNoC();
                        break;
                    }
                    if (thisKey.equals("arcs:")) {
                        this.keywordCelArC();
                        break;
                    }
                    if (thisKey.equals("porttypes:")) {
                        this.keywordCelPtC();
                        break;
                    }
                    if (thisKey.equals("technology:")) {
                        this.keywordTech();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 3: {
                    if (thisKey.equals("bits:")) {
                        this.keywordPtBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordPtUsb();
                        break;
                    }
                    if (thisKey.equals("subnode:")) {
                        this.keywordPtSNo();
                        break;
                    }
                    if (thisKey.equals("subport:")) {
                        this.keywordPtSPt();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordPtNam();
                        break;
                    }
                    if (thisKey.equals("descript:")) {
                        this.keywordPtDes();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordPtKse();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 4: {
                    if (thisKey.equals("bits:")) {
                        this.keywordNodBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordNodUsb();
                        break;
                    }
                    if (thisKey.equals("type:")) {
                        this.keywordNodTyp();
                        break;
                    }
                    if (thisKey.equals("lowx:")) {
                        this.keywordNodLX();
                        break;
                    }
                    if (thisKey.equals("highx:")) {
                        this.keywordNodHX();
                        break;
                    }
                    if (thisKey.equals("lowy:")) {
                        this.keywordNodLY();
                        break;
                    }
                    if (thisKey.equals("highy:")) {
                        this.keywordNodHY();
                        break;
                    }
                    if (thisKey.equals("rotation:")) {
                        this.keywordNodRot();
                        break;
                    }
                    if (thisKey.equals("transpose:")) {
                        this.keywordNodTra();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordNodKse();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordNodNam();
                        break;
                    }
                    if (thisKey.equals("descript:")) {
                        this.keywordNodDes();
                        break;
                    }
                    if (thisKey.equals("*port:")) {
                        this.keywordNewPor();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("ports:")) break;
                    this.keywordNodPoC();
                    break;
                }
                case 5: {
                    if (thisKey.equals("*port:")) {
                        this.keywordNewPor();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                    break;
                }
                case 6: {
                    if (thisKey.equals("bits:")) {
                        this.keywordArcBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordArcUsb();
                        break;
                    }
                    if (thisKey.equals("type:")) {
                        this.keywordArcTyp();
                        break;
                    }
                    if (thisKey.equals("width:")) {
                        this.keywordArcWid();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordArcKse();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordArcNam();
                        break;
                    }
                    if (thisKey.equals("*end:")) {
                        this.keywordNewEnd();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                    break;
                }
                case 7: {
                    if (thisKey.equals("node:")) {
                        this.keywordEndNod();
                        break;
                    }
                    if (thisKey.equals("nodeport:")) {
                        this.keywordEndPt();
                        break;
                    }
                    if (thisKey.equals("xpos:")) {
                        this.keywordEndXP();
                        break;
                    }
                    if (thisKey.equals("ypos:")) {
                        this.keywordEndYP();
                        break;
                    }
                    if (thisKey.equals("*end:")) {
                        this.keywordNewEnd();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                }
            }
        }
        if (this.allCellsArray == null) {
            return true;
        }
        this.lib.clearChanged();
        return false;
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> markCellForNodes, String scaledCellName, double scale) {
        if (cell.getLibrary() != this.lib) {
            return;
        }
        if (scaledCellName != null) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (this.nodeInstList == null) {
            return;
        }
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        NodeProto[] nodePrototypes = null;
        if (nil != null) {
            nodePrototypes = nil.protoType;
            numNodes = nodePrototypes.length;
        }
        this.scanNodesForRecursion(cell, markCellForNodes, nodePrototypes, 0, numNodes);
        ReadableDump.setProgressValue(++cellsConstructed * 100 / totalCells);
        double lambda = this.cellLambda[cellIndex];
        Point2D offset = this.realizeNodes(cell, nil, lambda);
        this.nodeProtoOffX[cellIndex] = offset.getX();
        this.nodeProtoOffY[cellIndex] = offset.getY();
        this.realizeExports(cell, cellIndex);
        this.realizeArcs(cell, cellIndex);
        cell.loadExpandStatus();
    }

    @Override
    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        if (nil != null) {
            numNodes = nil.protoType.length;
        }
        double thisLambda = this.cellLambda[cellIndex];
        for (int i = 0; i < numNodes; ++i) {
            int subCellIndex;
            double subLambda;
            NodeProto np = nil.protoType[i];
            if (np == null || np instanceof PrimitiveNode) continue;
            Cell subCell = (Cell)np;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || (subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) == thisLambda) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    @Override
    protected void computeTech(Cell cell, Set uncomputedCells) {
        int cellIndex;
        uncomputedCells.remove(cell);
        for (cellIndex = 0; cellIndex < this.nodeProtoCount && this.nodeProtoList[cellIndex] != cell; ++cellIndex) {
        }
        if (cellIndex >= this.nodeProtoCount || this.nodeInstList == null) {
            return;
        }
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        NodeProto[] nodePrototypes = null;
        if (nil != null) {
            nodePrototypes = nil.protoType;
            numNodes = nodePrototypes.length;
        }
        for (int i = 0; i < numNodes; ++i) {
            Cell subCell;
            LibraryFiles reader;
            NodeProto np = nodePrototypes[i];
            if (!uncomputedCells.contains(np) || (reader = this.getReaderForLib((subCell = (Cell)np).getLibrary())) == null) continue;
            reader.computeTech(subCell, uncomputedCells);
        }
        ArcInstList ail = this.arcInstList[cellIndex];
        int numArcs = 0;
        ArcProto[] arcPrototypes = null;
        if (ail != null) {
            arcPrototypes = ail.arcProto;
            numArcs = arcPrototypes.length;
        }
        Technology cellTech = Technology.whatTechnology(cell, nodePrototypes, 0, numNodes, arcPrototypes, 0, numArcs);
        cell.setTechnology(cellTech);
    }

    @Override
    protected double computeLambda(Cell cell, int cellIndex) {
        Technology cellTech = cell.getTechnology();
        double lambda = 1.0;
        if (cellTech != null) {
            for (int i = 0; i < this.techList.length; ++i) {
                if (this.techList[i] != cellTech) continue;
                lambda = this.lambdaValues[i];
                break;
            }
        }
        return lambda;
    }

    private Point2D realizeNodes(Cell cell, LibraryFiles.NodeInstList nil, double lambda) {
        int xoff = 0;
        int yoff = 0;
        int numNodes = 0;
        if (nil != null) {
            numNodes = nil.protoType.length;
        }
        for (int j = 0; j < numNodes; ++j) {
            NodeProto np = nil.protoType[j];
            if (np != Generic.tech.cellCenterNode) continue;
            this.realizeNode(nil, j, xoff, yoff, lambda, cell, np);
            xoff = (nil.lowX[j] + nil.highX[j]) / 2;
            yoff = (nil.lowY[j] + nil.highY[j]) / 2;
            break;
        }
        Point2D.Double offset = new Point2D.Double(xoff, yoff);
        for (int j = 0; j < numNodes; ++j) {
            NodeProto np = nil.protoType[j];
            if (np == null || np == Generic.tech.cellCenterNode) continue;
            this.realizeNode(nil, j, xoff, yoff, lambda, cell, np);
        }
        return offset;
    }

    private void realizeExports(Cell cell, int cellIndex) {
        ExportList el = this.exportList[cellIndex];
        int numExports = 0;
        if (el != null) {
            numExports = el.exportList.length;
        }
        for (int j = 0; j < numExports; ++j) {
            Export pp;
            NodeInst subNi = this.nodeInstList[cellIndex].theNode[el.exportSubNode[j]];
            PortInst pi = this.findProperPortInst(subNi, el.exportSubPort[j]);
            int userBits = this.exportList[this.curCellNumber].exportUserBits[this.curExportIndex];
            boolean alwaysDrawn = Export.alwaysDrawnFromElib(userBits);
            boolean bodyOnly = Export.bodyOnlyFromElib(userBits);
            PortCharacteristic characteristic = Export.portCharacteristicFromElib(userBits);
            ((ExportList)el).exportList[j] = pp = Export.newInstance(cell, el.exportName[j], null, this.exportList[this.curCellNumber].exportNameDescriptor[this.curExportIndex], pi, alwaysDrawn, bodyOnly, characteristic, errorLogger);
            if (pp == null) continue;
            this.realizeVariables(pp, el.exportVars[j]);
        }
    }

    private PortInst findProperPortInst(NodeInst ni, String portName) {
        NodeProto np = ni.getProto();
        PortProto pp = ReadableDump.findPortProto(np, portName);
        if (pp == null && !ni.isCellInstance()) {
            Technology tech = np.getTechnology();
            pp = tech.convertOldPortName(portName, (PrimitiveNode)np);
        }
        if (pp == null) {
            return null;
        }
        return ni.findPortInstFromProto(pp);
    }

    private void realizeArcs(Cell cell, int cellIndex) {
        ArcInstList ail = this.arcInstList[cellIndex];
        int numArcs = 0;
        if (ail != null) {
            numArcs = ail.arcProto.length;
        }
        double lambda = this.cellLambda[cellIndex];
        double xoff = this.nodeProtoOffX[cellIndex];
        double yoff = this.nodeProtoOffY[cellIndex];
        for (int j = 0; j < numArcs; ++j) {
            ArcInst ai;
            ArcProto ap = ail.arcProto[j];
            String name = ail.arcInstName[j];
            double width = (double)ail.arcWidth[j] / lambda;
            NodeInst arcHeadNode = this.nodeInstList[cellIndex].theNode[ail.arcHeadNode[j]];
            NodeInst arcTailNode = this.nodeInstList[cellIndex].theNode[ail.arcTailNode[j]];
            if (!arcHeadNode.isLinked() || !arcTailNode.isLinked()) continue;
            PortInst headPortInst = this.findProperPortInst(arcHeadNode, ail.arcHeadPort[j]);
            PortInst tailPortInst = this.findProperPortInst(arcTailNode, ail.arcTailPort[j]);
            if (ap == null || headPortInst == null || tailPortInst == null) continue;
            double headX = ((double)ail.arcHeadX[j] - xoff) / lambda;
            double headY = ((double)ail.arcHeadY[j] - yoff) / lambda;
            double tailX = ((double)ail.arcTailX[j] - xoff) / lambda;
            double tailY = ((double)ail.arcTailY[j] - yoff) / lambda;
            EPoint headPt = new EPoint(headX, headY);
            EPoint tailPt = new EPoint(tailX, tailY);
            int userBits = ail.arcUserBits[j];
            Poly poly = headPortInst.getPoly();
            if (!poly.isInside(headPt)) {
                System.out.println("Cell " + cell.describe(true) + ", " + ap + " head at (" + ail.arcHeadX[j] + "," + ail.arcHeadY[j] + ") not in port");
            }
            if (!(poly = tailPortInst.getPoly()).isInside(tailPt)) {
                System.out.println("Cell " + cell.describe(true) + ", " + ap + " tail at (" + ail.arcTailX[j] + "," + ail.arcTailY[j] + ") not in port");
            }
            ((ArcInstList)ail).arcList[j] = ai = ArcInst.newInstance(cell, ap, name, ail.arcNameDescriptor[j], headPortInst, tailPortInst, headPt, tailPt, width, ImmutableArcInst.angleFromElib(userBits), ImmutableArcInst.flagsFromElib(userBits));
            if (ai == null) {
                String msg = "ERROR: " + cell + ": arc " + name + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            this.realizeVariables(ai, ail.arcVars[j]);
        }
    }

    private boolean getKeyword() throws IOException {
        int filePostionDelta = 0;
        int c = 0;
        do {
            if ((c = this.lineReader.read()) == -1) {
                return true;
            }
            ++filePostionDelta;
        } while (c == 32);
        int cindex = 0;
        boolean inQuote = false;
        if (c == 34) {
            inQuote = true;
        }
        if (this.keywordArray == null) {
            this.keywordArrayLen = 500;
            this.keywordArray = new char[this.keywordArrayLen];
        }
        this.keywordArray[cindex++] = (char)c;
        while (true) {
            if ((c = this.lineReader.read()) == -1) {
                return true;
            }
            ++filePostionDelta;
            if (c == 10 || c == 32 && !inQuote) break;
            if (c == 34 && (cindex == 0 || this.keywordArray[cindex - 1] != '^')) {
                boolean bl = inQuote = !inQuote;
            }
            if (cindex >= this.keywordArrayLen) {
                int newKeywordArrayLen = this.keywordArrayLen * 2;
                char[] newKeywordArray = new char[newKeywordArrayLen];
                for (int i = 0; i < this.keywordArrayLen; ++i) {
                    newKeywordArray[i] = this.keywordArray[i];
                }
                this.keywordArray = newKeywordArray;
                this.keywordArrayLen = newKeywordArrayLen;
            }
            this.keywordArray[cindex++] = (char)c;
        }
        this.keyWord = new String(this.keywordArray, 0, cindex);
        this.updateProgressDialog(filePostionDelta);
        return false;
    }

    private void keywordNewLib() {
        this.varPos = 1;
        this.curTech = null;
        this.textLevel = 1;
    }

    private void keywordVersn() {
        this.version = Version.parseVersion(this.keyWord);
        this.convertMosisCmosTechnologies = this.version.compareTo(Version.parseVersion("6.03q")) < 0;
        this.scaleLambdaBy20 = this.version.compareTo(Version.parseVersion("5")) < 0;
        this.rotationMirrorBits = this.version.compareTo(Version.parseVersion("7.01")) >= 0;
    }

    private void keywordLibKno() {
        this.bitCount = 0;
        this.toolList = new Tool[Integer.parseInt(this.keyWord)];
    }

    private void keywordLibAiN() {
        this.curTool = Tool.findTool(this.keyWord);
        this.toolList[this.bitCount++] = this.curTool;
    }

    private void keywordLibAiB() {
        this.bitCount = 0;
    }

    private void keywordLibBit() {
        if (this.bitCount == 0) {
            this.lib.lowLevelSetUserBits(TextUtils.atoi(this.keyWord));
        }
        ++this.bitCount;
    }

    private void keywordLibUsb() {
        this.lib.lowLevelSetUserBits(TextUtils.atoi(this.keyWord));
        this.lib.clearFromDisk();
    }

    private void keywordLibTe() {
        this.varPos = 2;
        this.bitCount = 0;
        int numTechs = Integer.parseInt(this.keyWord);
        this.techList = new Technology[numTechs];
        this.lambdaValues = new int[numTechs];
    }

    private void keywordLibTeN() {
        this.curTech = Technology.findTechnology(this.keyWord);
        this.techList[this.bitCount++] = this.curTech;
    }

    private void keywordLambda() {
        int lam = Integer.parseInt(this.keyWord);
        if (this.scaleLambdaBy20) {
            lam *= 20;
        }
        this.lambdaValues[this.bitCount - 1] = lam;
    }

    private void keywordLibCC() {
        this.varPos = 3;
        this.nodeProtoCount = Integer.parseInt(this.keyWord);
        if (this.nodeProtoCount == 0) {
            return;
        }
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.allCellsArray = new Cell[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.nodeProtoOffX = new double[this.nodeProtoCount];
        this.nodeProtoOffY = new double[this.nodeProtoCount];
        this.nodeInstList = new LibraryFiles.NodeInstList[this.nodeProtoCount];
        this.arcInstList = new ArcInstList[this.nodeProtoCount];
        this.exportList = new ExportList[this.nodeProtoCount];
    }

    private void keywordLibMS() {
    }

    private void keywordLibVie() {
        int openCurly = this.keyWord.indexOf(123);
        if (openCurly < 0) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '{' in view name: " + this.keyWord);
            return;
        }
        String fullName = this.keyWord.substring(0, openCurly);
        String abbrev = this.keyWord.substring(openCurly + 1);
        int closeCurly = abbrev.indexOf(125);
        if (closeCurly < 0) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '}' in view name: " + this.keyWord);
            return;
        }
        abbrev = abbrev.substring(0, closeCurly);
        View v = View.findView(fullName);
        if (v == null && (v = this.findOldViewName(fullName)) != null) {
            abbrev = v.getAbbreviation();
        }
        if (v == null) {
            v = View.newInstance(fullName, abbrev);
        } else if (!v.getAbbreviation().equals(abbrev)) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": view " + fullName + " has abbreviation '" + abbrev + "' which does not match the existing abbreviation '" + v.getAbbreviation() + "'");
            return;
        }
    }

    private void keywordNewCel() {
        this.curCellNumber = TextUtils.atoi(this.keyWord);
        this.curCell = null;
        this.curCellName = null;
        this.curCellRevisionDate = 0;
        this.curCellCreationDate = 0;
        this.curCellTech = null;
        this.curCellUserbits = 0;
        this.curCellHighY = 0;
        this.curCellLowY = 0;
        this.curCellHighX = 0;
        this.curCellLowX = 0;
        this.curCellGroup = -1;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            this.curCellGroup = TextUtils.atoi(this.keyWord.substring(slashPos + 1));
        }
        this.textLevel = 2;
        this.varPos = 4;
    }

    private void keywordCelNam() {
        this.curCellName = CellName.parseName(this.convertCellName(this.keyWord));
    }

    private void keywordCelVer() {
        this.curCellName = CellName.newName(this.curCellName.getName(), this.curCellName.getView(), TextUtils.atoi(this.keyWord));
    }

    private void keywordCelCre() {
        this.curCellCreationDate = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelRev() {
        this.curCellRevisionDate = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelLX() {
        this.curCellLowX = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelHX() {
        this.curCellHighX = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelLY() {
        this.curCellLowY = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelHY() {
        this.curCellHighY = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelBit() {
        this.curCellUserbits = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelUsb() {
        this.curCellUserbits = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelExt() {
        String withoutQuotes = this.keyWord;
        if (withoutQuotes.charAt(0) == '\"' && (withoutQuotes = withoutQuotes.substring(1)).endsWith("\"")) {
            withoutQuotes = withoutQuotes.substring(0, withoutQuotes.length() - 1);
        }
        Library elib = this.readExternalLibraryFromFilename(withoutQuotes, FileType.ELIB);
        Cell cell = null;
        if (elib != null && (cell = elib.findNodeProto(this.curCellName.toString())) != null && cell.getRevisionDate().compareTo(ELIBConstants.secondsToDate(this.curCellRevisionDate)) != 0) {
            System.out.println("Warning: " + cell + " in " + elib + " has been modified since its use in " + this.lib);
        }
        if (cell != null) {
            this.curCell = cell;
            this.allCellsArray[this.curCellNumber] = cell;
            this.nodeProtoList[this.curCellNumber] = null;
        } else {
            LibraryFiles.NodeInstList nil;
            String elibName = null;
            if (elib != null) {
                elibName = elib.getName();
            } else {
                File libFile = new File(withoutQuotes);
                elibName = libFile.getName();
                int lastDotPos = elibName.lastIndexOf(46);
                if (lastDotPos > 0) {
                    elibName = elibName.substring(0, lastDotPos);
                }
            }
            System.out.println("Cannot find cell " + this.curCellName.toString() + " in library " + elibName + "...creating dummy version");
            this.curCellName = this.curCellName.getVersion() != 0 ? CellName.parseName(this.curCellName.getName() + "FROM" + elibName + ";" + this.curCellName.getVersion() + "{" + this.curCellName.getView().getAbbreviation() + "}") : CellName.parseName(this.curCellName.getName() + "FROM" + elibName + "{" + this.curCellName.getView().getAbbreviation() + "}");
            this.finishCellInitialization();
            this.nodeInstList[this.curCellNumber] = nil = new LibraryFiles.NodeInstList(2, false);
            nil.protoType[0] = Generic.tech.cellCenterNode;
            nil.name[0] = null;
            nil.lowX[0] = 0;
            nil.highX[0] = 0;
            nil.lowY[0] = 0;
            nil.highY[0] = 0;
            nil.rotation[0] = 0;
            nil.transpose[0] = 0;
            nil.protoType[1] = Artwork.tech.crossedBoxNode;
            nil.name[1] = null;
            nil.lowX[1] = this.curCellLowX;
            nil.highX[1] = this.curCellHighX;
            nil.lowY[1] = this.curCellLowY;
            nil.highY[1] = this.curCellHighY;
            nil.rotation[1] = 0;
            nil.transpose[1] = 0;
        }
    }

    private void finishCellInitialization() {
        this.nodeProtoList[this.curCellNumber] = this.curCell = Cell.newInstance(this.lib, this.curCellName.toString());
        this.allCellsArray[this.curCellNumber] = this.curCell;
        this.curCell.setTempInt(this.curCellGroup);
        if (this.curCellTech != null) {
            this.curCell.setTechnology(this.curCellTech);
        }
        this.curCell.lowLevelSetCreationDate(ELIBConstants.secondsToDate(this.curCellCreationDate));
        this.curCell.lowLevelSetRevisionDate(ELIBConstants.secondsToDate(this.curCellRevisionDate));
        this.curCell.lowLevelSetUserbits(this.curCellUserbits);
    }

    private void keywordTech() {
        Technology tech;
        this.curCellTech = tech = this.findTechnologyName(this.keyWord);
    }

    private void keywordCelNoC() {
        this.finishCellInitialization();
        int nodeInstCount = Integer.parseInt(this.keyWord);
        if (nodeInstCount == 0) {
            return;
        }
        this.nodeInstList[this.curCellNumber] = new LibraryFiles.NodeInstList(nodeInstCount, false);
    }

    private void keywordCelArC() {
        ArcInstList ail;
        int arcInstCount = Integer.parseInt(this.keyWord);
        if (arcInstCount == 0) {
            return;
        }
        this.arcInstList[this.curCellNumber] = ail = new ArcInstList();
        ArcInstList.access$2002(ail, new ArcInst[arcInstCount]);
        ArcInstList.access$002(ail, new ArcProto[arcInstCount]);
        ArcInstList.access$802(ail, new String[arcInstCount]);
        ArcInstList.access$902(ail, new int[arcInstCount]);
        ArcInstList.access$1002(ail, new int[arcInstCount]);
        ArcInstList.access$1202(ail, new String[arcInstCount]);
        ArcInstList.access$1402(ail, new int[arcInstCount]);
        ArcInstList.access$1502(ail, new int[arcInstCount]);
        ArcInstList.access$1102(ail, new int[arcInstCount]);
        ArcInstList.access$1302(ail, new String[arcInstCount]);
        ArcInstList.access$1602(ail, new int[arcInstCount]);
        ArcInstList.access$1702(ail, new int[arcInstCount]);
        ArcInstList.access$1802(ail, new int[arcInstCount]);
        ArcInstList.access$2102(ail, new Variable[arcInstCount][]);
    }

    private void keywordCelPtC() {
        ExportList el;
        int exportCount = Integer.parseInt(this.keyWord);
        if (exportCount == 0) {
            return;
        }
        this.exportList[this.curCellNumber] = el = new ExportList();
        ExportList.access$102(el, new Export[exportCount]);
        ExportList.access$502(el, new String[exportCount]);
        ExportList.access$602(el, new TextDescriptor[exportCount]);
        ExportList.access$202(el, new int[exportCount]);
        ExportList.access$302(el, new String[exportCount]);
        ExportList.access$402(el, new int[exportCount]);
        ExportList.access$702(el, new Variable[exportCount][]);
    }

    private void keywordNewNo() {
        this.curNodeInstIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 4;
        this.varPos = 5;
    }

    private void keywordNodTyp() {
        NodeProto curNodeInstProto = null;
        int openSquare = this.keyWord.indexOf(91);
        if (openSquare >= 0) {
            curNodeInstProto = this.allCellsArray[TextUtils.atoi(this.keyWord, openSquare + 1)];
        } else {
            curNodeInstProto = Cell.findNodeProto(this.keyWord);
            if (curNodeInstProto == null) {
                Technology tech = null;
                int colonPos = this.keyWord.indexOf(58);
                if (colonPos >= 0) {
                    tech = Technology.findTechnology(this.keyWord.substring(0, colonPos));
                }
                if (tech != null && this.keyWord.equals("Active-Node") && (curNodeInstProto = tech.findNodeProto("P-Active-Node")) == null) {
                    curNodeInstProto = tech.convertOldNodeName(this.keyWord);
                }
            }
        }
        if (curNodeInstProto == null) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": unknown node type: " + this.keyWord);
        }
        this.nodeInstList[this.curCellNumber].protoType[this.curNodeInstIndex] = curNodeInstProto;
    }

    private void keywordNodLX() {
        this.nodeInstList[this.curCellNumber].lowX[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodHX() {
        this.nodeInstList[this.curCellNumber].highX[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodLY() {
        this.nodeInstList[this.curCellNumber].lowY[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodHY() {
        this.nodeInstList[this.curCellNumber].highY[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodNam() {
        this.nodeInstList[this.curCellNumber].name[this.curNodeInstIndex] = this.keyWord;
    }

    private void keywordNodDes() {
        int td0 = TextUtils.atoi(this.keyWord);
        int td1 = 0;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            td1 = TextUtils.atoi(this.keyWord.substring(slashPos + 1));
        }
        this.nodeInstList[this.curCellNumber].protoTextDescriptor[this.curNodeInstIndex] = this.makeDescriptor(td0, td1);
    }

    private void keywordNodRot() {
        this.nodeInstList[this.curCellNumber].rotation[this.curNodeInstIndex] = (short)Integer.parseInt(this.keyWord);
    }

    private void keywordNodTra() {
        this.nodeInstList[this.curCellNumber].transpose[this.curNodeInstIndex] = Integer.parseInt(this.keyWord);
    }

    private void keywordNodKse() {
        this.bitCount = 0;
    }

    private void keywordNodPoC() {
    }

    private void keywordNodBit() {
        if (this.bitCount == 0) {
            this.nodeInstList[this.curCellNumber].userBits[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordNodUsb() {
        this.nodeInstList[this.curCellNumber].userBits[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewPor() {
        this.textLevel = 5;
    }

    private void keywordNewAr() {
        this.curArcInstIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 6;
        this.varPos = 7;
    }

    private void keywordArcTyp() {
        ArcProto curArcInstProto = null;
        curArcInstProto = ArcProto.findArcProto(this.keyWord);
        if (curArcInstProto == null) {
            Technology tech = null;
            int colonPos = this.keyWord.indexOf(58);
            if (colonPos >= 0) {
                tech = Technology.findTechnology(this.keyWord.substring(0, colonPos));
            }
            if (tech != null) {
                curArcInstProto = tech.convertOldArcName(this.keyWord);
            }
        }
        if (curArcInstProto == null) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": unknown arc type: " + this.keyWord);
        }
        ((ArcInstList)this.arcInstList[this.curCellNumber]).arcProto[this.curArcInstIndex] = curArcInstProto;
    }

    private void keywordArcNam() {
        ((ArcInstList)this.arcInstList[this.curCellNumber]).arcInstName[this.curArcInstIndex] = this.keyWord;
    }

    private void keywordArcWid() {
        ((ArcInstList)this.arcInstList[this.curCellNumber]).arcWidth[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewEnd() {
        this.curArcEnd = Integer.parseInt(this.keyWord);
        this.textLevel = 7;
    }

    private void keywordEndNod() {
        int endIndex = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcHeadNode[this.curArcInstIndex] = endIndex;
        } else {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcTailNode[this.curArcInstIndex] = endIndex;
        }
    }

    private void keywordEndPt() {
        if (this.curArcEnd == 1) {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcHeadPort[this.curArcInstIndex] = this.keyWord;
        } else {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcTailPort[this.curArcInstIndex] = this.keyWord;
        }
    }

    private void keywordEndXP() {
        int x = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcHeadX[this.curArcInstIndex] = x;
        } else {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcTailX[this.curArcInstIndex] = x;
        }
    }

    private void keywordEndYP() {
        int y = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcHeadY[this.curArcInstIndex] = y;
        } else {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcTailY[this.curArcInstIndex] = y;
        }
    }

    private void keywordArcKse() {
        this.bitCount = 0;
    }

    private void keywordArcBit() {
        if (this.bitCount == 0) {
            ((ArcInstList)this.arcInstList[this.curCellNumber]).arcUserBits[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordArcUsb() {
        ((ArcInstList)this.arcInstList[this.curCellNumber]).arcUserBits[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewPt() {
        this.curExportIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 3;
        this.varPos = 6;
    }

    private void keywordPtNam() {
        ((ExportList)this.exportList[this.curCellNumber]).exportName[this.curExportIndex] = this.keyWord;
    }

    private void keywordPtDes() {
        int td0 = TextUtils.atoi(this.keyWord);
        int td1 = 0;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            td1 = TextUtils.atoi(this.keyWord, slashPos + 1);
        }
        ((ExportList)this.exportList[this.curCellNumber]).exportNameDescriptor[this.curExportIndex] = this.makeDescriptor(td0, td1);
    }

    private void keywordPtSNo() {
        int index;
        ((ExportList)this.exportList[this.curCellNumber]).exportSubNode[this.curExportIndex] = index = Integer.parseInt(this.keyWord);
    }

    private void keywordPtSPt() {
        ((ExportList)this.exportList[this.curCellNumber]).exportSubPort[this.curExportIndex] = this.keyWord;
    }

    private void keywordPtKse() {
        this.bitCount = 0;
    }

    private void keywordPtBit() {
        if (this.bitCount == 0) {
            ((ExportList)this.exportList[this.curCellNumber]).exportUserBits[this.curExportIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordPtUsb() {
        ((ExportList)this.exportList[this.curCellNumber]).exportUserBits[this.curExportIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordGetVar() throws IOException {
        Variable[] vars = this.parseVars();
        switch (this.varPos) {
            case 5: {
                this.nodeInstList[this.curCellNumber].vars[this.curNodeInstIndex] = vars;
                for (int i = 0; i < vars.length; ++i) {
                    Object value;
                    Variable var = vars[i];
                    if (var == null || var.getKey() != NodeInst.NODE_NAME || !((value = var.getObject()) instanceof String)) continue;
                    this.nodeInstList[this.curCellNumber].name[this.curNodeInstIndex] = ReadableDump.convertGeomName((String)value, var.isDisplay());
                    this.nodeInstList[this.curCellNumber].nameTextDescriptor[this.curNodeInstIndex] = var.getTextDescriptor();
                    vars[i] = null;
                }
                break;
            }
            case 6: {
                ((ExportList)this.exportList[this.curCellNumber]).exportVars[this.curExportIndex] = vars;
                break;
            }
            case 7: {
                ((ArcInstList)this.arcInstList[this.curCellNumber]).arcVars[this.curArcInstIndex] = vars;
                for (int i = 0; i < vars.length; ++i) {
                    Object value;
                    Variable var = vars[i];
                    if (var == null || var.getKey() != ArcInst.ARC_NAME || !((value = var.getObject()) instanceof String)) continue;
                    ((ArcInstList)this.arcInstList[this.curCellNumber]).arcInstName[this.curArcInstIndex] = ReadableDump.convertGeomName((String)value, var.isDisplay());
                    ((ArcInstList)this.arcInstList[this.curCellNumber]).arcNameDescriptor[this.curArcInstIndex] = var.getTextDescriptor();
                    vars[i] = null;
                }
                break;
            }
            case 1: {
                if (!this.topLevelLibrary) break;
                this.realizeMeaningPrefs(this.curTool, vars);
                break;
            }
            case 2: {
                if (!this.topLevelLibrary) break;
                this.realizeMeaningPrefs(this.curTech, vars);
                break;
            }
            case 3: {
                for (int i = 0; i < vars.length; ++i) {
                    Object value;
                    Variable var = vars[i];
                    if (var == null || var.getKey() != Library.FONT_ASSOCIATIONS || !((value = var.getObject()) instanceof String[])) continue;
                    this.setFontNames((String[])value);
                    vars[i] = null;
                }
                this.realizeVariables(this.lib, vars);
                break;
            }
            case 4: {
                this.realizeVariables(this.curCell, vars);
            }
        }
    }

    private Variable[] parseVars() throws IOException {
        int count = Integer.parseInt(this.keyWord);
        if (count <= 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[count];
        for (int i = 0; i < count; ++i) {
            Object[] value;
            TextDescriptor td;
            String varName;
            block41: {
                int type;
                int len;
                block40: {
                    int openSquarePos;
                    if (this.getKeyword()) {
                        System.out.println("EOF too soon");
                        return vars;
                    }
                    varName = "";
                    len = this.keyWord.length();
                    if (this.keyWord.charAt(len - 1) != ':') {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing colon in variable specification: " + this.keyWord);
                        return vars;
                    }
                    for (int j = 0; j < len; ++j) {
                        char cat = this.keyWord.charAt(j);
                        if (cat == '^' && j < len - 1) {
                            varName = varName + this.keyWord.charAt(++j);
                            continue;
                        }
                        if (cat == '(' || cat == '[' || cat == ':') break;
                        varName = varName + cat;
                    }
                    if ((openSquarePos = this.keyWord.lastIndexOf(91)) < 0) {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing type information in variable: " + this.keyWord);
                        return vars;
                    }
                    type = TextUtils.atoi(this.keyWord, openSquarePos + 1);
                    int commaPos = this.keyWord.indexOf(44);
                    int td0 = 0;
                    int td1 = 0;
                    if (commaPos >= 0) {
                        td0 = TextUtils.atoi(this.keyWord, commaPos + 1);
                        td1 = 0;
                        int slashPos = this.keyWord.indexOf(47);
                        if (slashPos >= 0) {
                            td1 = TextUtils.atoi(this.keyWord, slashPos + 1);
                        }
                    }
                    td = this.makeDescriptor(td0, td1, type);
                    if (this.getKeyword()) {
                        System.out.println("EOF too soon");
                        return vars;
                    }
                    value = null;
                    if ((type & 0x80) != 0) break block40;
                    value = this.variableDecode(this.keyWord, type);
                    break block41;
                }
                if (this.keyWord.charAt(0) != '[') {
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '[' in list of variable values: " + this.keyWord);
                    return vars;
                }
                ArrayList<Object> al = new ArrayList<Object>();
                int pos = 1;
                len = this.keyWord.length();
                while (true) {
                    int start;
                    block43: {
                        block42: {
                            start = ++pos;
                            if ((type & 0x1F) != 4) break block42;
                            while (this.keyWord.charAt(pos) != '\"' && pos < len - 1) {
                                ++pos;
                            }
                            start = pos;
                            if (pos >= len) break block43;
                            ++pos;
                            while (true) {
                                if (this.keyWord.charAt(pos) == '^' && pos < len - 1) {
                                    pos += 2;
                                    continue;
                                }
                                if (this.keyWord.charAt(pos) == '\"' || pos == len - 1) break;
                                ++pos;
                            }
                            if (pos >= len) break block43;
                            ++pos;
                            break block43;
                        }
                        while (this.keyWord.charAt(pos) != ',' && this.keyWord.charAt(pos) != ']' && pos < len) {
                            ++pos;
                        }
                    }
                    if (pos >= len) {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": array too short in variable values: " + this.keyWord);
                        return vars;
                    }
                    String entry = this.keyWord.substring(start, pos);
                    al.add(this.variableDecode(entry, type));
                    if (this.keyWord.charAt(pos) == ']') break;
                    if (this.keyWord.charAt(pos) == ',') continue;
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing comma between array entries: " + this.keyWord);
                    return vars;
                }
                int arrayLen = al.size();
                switch (type & 0x1F) {
                    case 1: 
                    case 2: {
                        value = new Integer[arrayLen];
                        break;
                    }
                    case 5: 
                    case 19: {
                        value = new Float[arrayLen];
                        break;
                    }
                    case 6: {
                        value = new Double[arrayLen];
                        break;
                    }
                    case 25: {
                        value = new Short[arrayLen];
                        break;
                    }
                    case 3: 
                    case 30: {
                        value = new Byte[arrayLen];
                        break;
                    }
                    case 4: {
                        value = new String[arrayLen];
                        break;
                    }
                    case 8: {
                        value = new NodeProto[arrayLen];
                        break;
                    }
                    case 13: {
                        value = new ArcProto[arrayLen];
                        break;
                    }
                    case 11: {
                        value = new ExportId[arrayLen];
                        break;
                    }
                    case 16: {
                        value = new Technology[arrayLen];
                        break;
                    }
                    case 15: {
                        value = new LibId[arrayLen];
                        break;
                    }
                    case 17: {
                        value = new Tool[arrayLen];
                    }
                }
                if (value != null) {
                    for (int j = 0; j < arrayLen; ++j) {
                        value[j] = al.get(j);
                    }
                }
                if (value instanceof NodeProtoId[]) {
                    int j;
                    NodeProtoId[] newAddrArray = (NodeProtoId[])value;
                    int numCells = 0;
                    int numPrims = 0;
                    for (int j2 = 0; j2 < newAddrArray.length; ++j2) {
                        if (newAddrArray[j2] == null) continue;
                        if (newAddrArray[j2] instanceof CellId) {
                            ++numCells;
                        }
                        if (!(newAddrArray[j2] instanceof PrimitiveNode)) continue;
                        ++numPrims;
                    }
                    if (numCells >= numPrims) {
                        CellId[] cellArray = new CellId[newAddrArray.length];
                        for (j = 0; j < cellArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof CellId)) continue;
                            cellArray[j] = (CellId)newAddrArray[j];
                        }
                        value = cellArray;
                    } else {
                        PrimitiveNode[] primArray = new PrimitiveNode[newAddrArray.length];
                        for (j = 0; j < primArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof PrimitiveNode)) continue;
                            primArray[j] = (PrimitiveNode)newAddrArray[j];
                        }
                        value = primArray;
                    }
                }
            }
            if (value == null) continue;
            vars[i] = Variable.newInstance(Variable.newKey(varName), value, td);
        }
        return vars;
    }

    private Object variableDecode(String name, int type) {
        int thistype = type;
        if ((thistype & 0x20000020) != 0) {
            thistype = 4;
        }
        switch (thistype & 0x1F) {
            case 1: 
            case 2: 
            case 25: 
            case 30: {
                return new Integer(TextUtils.atoi(name));
            }
            case 19: {
                return new Float((float)TextUtils.atoi(name) / 120.0f);
            }
            case 3: {
                return new Character(name.charAt(0));
            }
            case 4: {
                char[] letters = new char[name.length()];
                int outpos = 0;
                int inpos = 0;
                if (name.charAt(inpos) == '\"') {
                    ++inpos;
                }
                while (inpos < name.length()) {
                    if (name.charAt(inpos) == '^' && inpos < name.length() - 1) {
                        letters[outpos++] = name.charAt(++inpos);
                    } else {
                        if (name.charAt(inpos) == '\"') break;
                        letters[outpos++] = name.charAt(inpos);
                    }
                    ++inpos;
                }
                return new String(letters, 0, outpos);
            }
            case 5: {
                return new Float(Float.parseFloat(name));
            }
            case 6: {
                return new Double(Double.parseDouble(name));
            }
            case 8: {
                int colonPos = name.indexOf(58);
                if (colonPos < 0) {
                    int cindex = Integer.parseInt(name);
                    return this.allCellsArray[cindex] != null ? this.allCellsArray[cindex].getId() : null;
                }
                NodeProto np = Cell.findNodeProto(name);
                if (np == null) {
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": cannot find node " + name);
                    return null;
                }
                return (PrimitiveNode)np;
            }
            case 11: {
                int ppIndex = TextUtils.atoi(name);
                Export pp = this.exportList[this.curCellNumber].exportList[ppIndex];
                if (!(pp instanceof Export)) {
                    return null;
                }
                return pp.getId();
            }
            case 13: {
                return ArcProto.findArcProto(name);
            }
            case 16: {
                return Technology.findTechnology(name);
            }
            case 17: {
                return Tool.findTool(name);
            }
        }
        return null;
    }

    private static class ExportList {
        private Export[] exportList;
        private String[] exportName;
        private TextDescriptor[] exportNameDescriptor;
        private int[] exportSubNode;
        private String[] exportSubPort;
        private int[] exportUserBits;
        private Variable[][] exportVars;

        private ExportList() {
        }

        static /* synthetic */ Export[] access$102(ExportList x0, Export[] x1) {
            x0.exportList = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(ExportList x0, String[] x1) {
            x0.exportName = x1;
            return x1;
        }

        static /* synthetic */ TextDescriptor[] access$602(ExportList x0, TextDescriptor[] x1) {
            x0.exportNameDescriptor = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(ExportList x0, int[] x1) {
            x0.exportSubNode = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(ExportList x0, String[] x1) {
            x0.exportSubPort = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(ExportList x0, int[] x1) {
            x0.exportUserBits = x1;
            return x1;
        }

        static /* synthetic */ Variable[][] access$702(ExportList x0, Variable[][] x1) {
            x0.exportVars = x1;
            return x1;
        }
    }

    private static class ArcInstList {
        private ArcInst[] arcList;
        private ArcProto[] arcProto;
        private String[] arcInstName;
        private TextDescriptor[] arcNameDescriptor;
        private int[] arcWidth;
        private int[] arcHeadNode;
        private String[] arcHeadPort;
        private int[] arcHeadX;
        private int[] arcHeadY;
        private int[] arcTailNode;
        private String[] arcTailPort;
        private int[] arcTailX;
        private int[] arcTailY;
        private int[] arcUserBits;
        private Variable[][] arcVars;

        private ArcInstList() {
        }

        static /* synthetic */ ArcInst[] access$2002(ArcInstList x0, ArcInst[] x1) {
            x0.arcList = x1;
            return x1;
        }

        static /* synthetic */ ArcProto[] access$002(ArcInstList x0, ArcProto[] x1) {
            x0.arcProto = x1;
            return x1;
        }

        static /* synthetic */ String[] access$802(ArcInstList x0, String[] x1) {
            x0.arcInstName = x1;
            return x1;
        }

        static /* synthetic */ int[] access$902(ArcInstList x0, int[] x1) {
            x0.arcWidth = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1002(ArcInstList x0, int[] x1) {
            x0.arcHeadNode = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1202(ArcInstList x0, String[] x1) {
            x0.arcHeadPort = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1402(ArcInstList x0, int[] x1) {
            x0.arcHeadX = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1502(ArcInstList x0, int[] x1) {
            x0.arcHeadY = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1102(ArcInstList x0, int[] x1) {
            x0.arcTailNode = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1302(ArcInstList x0, String[] x1) {
            x0.arcTailPort = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1602(ArcInstList x0, int[] x1) {
            x0.arcTailX = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1702(ArcInstList x0, int[] x1) {
            x0.arcTailY = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1802(ArcInstList x0, int[] x1) {
            x0.arcUserBits = x1;
            return x1;
        }

        static /* synthetic */ Variable[][] access$2102(ArcInstList x0, Variable[][] x1) {
            x0.arcVars = x1;
            return x1;
        }
    }
}

