/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Foundry {
    private Type type;
    private List<DRCTemplate> rules;
    private HashMap<String, Pref> gdsLayerPrefs = new HashMap();

    public Foundry(Type mode) {
        this.type = mode;
    }

    public Type getType() {
        return this.type;
    }

    public List<DRCTemplate> getRules() {
        return this.rules;
    }

    public void setRules(List<DRCTemplate> list) {
        this.rules = list;
    }

    public String toString() {
        return this.type.name();
    }

    public void setFactoryGDSLayer(Layer layer, String factoryDefault) {
        String value = factoryDefault.replaceAll(", ", ",");
        this.getLayerSetting(layer, this.getGDSPrefName(), this.gdsLayerPrefs, value);
    }

    public String getGDSLayer(Layer layer) {
        return this.getLayerSetting(layer, this.getGDSPrefName(), this.gdsLayerPrefs, null).getString();
    }

    private Pref getLayerSetting(Layer layer, String what, HashMap<String, Pref> map, String factory) {
        String techName = layer.getTechnology().getTechName();
        String key = layer.getName() + what + techName;
        Pref pref = map.get(key);
        if (pref == null) {
            if (factory == null) {
                factory = "";
            }
            pref = Pref.makeStringSetting(what + "LayerFor" + layer.getName() + "IN" + techName, Technology.getTechnologyPreferences(), layer.getTechnology(), this.getGDSNode(layer.getTechnology()), layer.getName(), what + " tab", what + " for layer " + layer.getName() + " in technology " + techName, factory);
            map.put(key, pref);
        }
        return pref;
    }

    public void setGDSLayer(Layer layer, String gdsLayer) {
        this.getLayerSetting(layer, this.getGDSPrefName(), this.gdsLayerPrefs, gdsLayer).setString(gdsLayer);
    }

    private String getGDSPrefName() {
        return "GDS(" + this.type.name() + ")";
    }

    private ProjSettingsNode getGDSNode(Technology tech) {
        ProjSettingsNode node = tech.getProjectSettings().getNode("GDS");
        if (this.type == Type.TSMC) {
            return node.getNode("TSMC");
        }
        if (this.type == Type.MOSIS) {
            return node.getNode("MOSIS");
        }
        if (this.type == Type.ST) {
            return node.getNode("ST");
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE(-1),
        TSMC(4096),
        ST(8192),
        MOSIS(16384);

        private final int mode;

        private Type(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }
}

