/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.technology.Layer;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CIFTab
extends PreferencePanel {
    private JList cifLayersList;
    private DefaultListModel cifLayersModel;
    private boolean changingCIF = false;
    private JPanel cif;
    private JCheckBox cifInputSquaresWires;
    private JTextField cifLayer;
    private JScrollPane cifLayers;
    private JCheckBox cifOutputInstantiatesTopLevel;
    private JCheckBox cifOutputMergesBoxes;
    private JCheckBox cifOutputMimicsDisplay;
    private JLabel cifTechnology;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public CIFTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.cif;
    }

    public String getName() {
        return "CIF";
    }

    public void init() {
        this.cifOutputMimicsDisplay.setSelected(IOTool.isCIFOutMimicsDisplay());
        this.cifOutputMergesBoxes.setSelected(IOTool.isCIFOutMergesBoxes());
        this.cifOutputInstantiatesTopLevel.setSelected(IOTool.isCIFOutInstantiatesTopLevel());
        this.cifInputSquaresWires.setSelected(IOTool.isCIFInSquaresWires());
        this.cifTechnology.setText("Technology " + this.curTech.getTechName() + ":");
        this.cifLayersModel = new DefaultListModel();
        this.cifLayersList = new JList(this.cifLayersModel);
        this.cifLayersList.setSelectionMode(0);
        this.cifLayers.setViewportView(this.cifLayersList);
        this.cifLayersList.clearSelection();
        this.cifLayersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CIFTab.this.cifClickLayer();
            }
        });
        this.cifLayersModel.clear();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String str = layer.getName();
            String cifLayer = layer.getCIFLayer();
            if (cifLayer == null) {
                cifLayer = "";
            }
            if (cifLayer.length() > 0) {
                str = str + " (" + cifLayer + ")";
            }
            this.cifLayersModel.addElement(str);
        }
        this.cifLayersList.setSelectedIndex(0);
        this.cifLayer.getDocument().addDocumentListener(new CIFDocumentListener(this));
        this.cifClickLayer();
    }

    private void cifClickLayer() {
        this.changingCIF = true;
        String str = (String)this.cifLayersList.getSelectedValue();
        this.cifLayer.setText(this.cifGetLayerName(str));
        this.changingCIF = false;
    }

    private String cifGetLayerName(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return "";
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return "";
        }
        String cifLayer = str.substring(openParen + 1, closeParen);
        return cifLayer;
    }

    private Layer cifGetLayer(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            openParen = str.length() + 1;
        }
        String layerName = str.substring(0, openParen - 1);
        Layer layer = this.curTech.findLayer(layerName);
        return layer;
    }

    private void cifLayerChanged() {
        if (this.changingCIF) {
            return;
        }
        String str = (String)this.cifLayersList.getSelectedValue();
        Layer layer = this.cifGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = layer.getName();
        String newLayer = this.cifLayer.getText().trim();
        if (newLayer.length() > 0) {
            newLine = newLine + " (" + newLayer + ")";
        }
        int index = this.cifLayersList.getSelectedIndex();
        this.cifLayersModel.set(index, newLine);
    }

    public void term() {
        for (int i = 0; i < this.cifLayersModel.getSize(); ++i) {
            String currentCIFNumbers;
            String str = (String)this.cifLayersModel.getElementAt(i);
            Layer layer = this.cifGetLayer(str);
            if (layer == null || (currentCIFNumbers = this.cifGetLayerName(str)).equalsIgnoreCase(layer.getCIFLayer())) continue;
            layer.setCIFLayer(currentCIFNumbers);
        }
        boolean currentValue = this.cifOutputMimicsDisplay.isSelected();
        if (currentValue != IOTool.isCIFOutMimicsDisplay()) {
            IOTool.setCIFOutMimicsDisplay(currentValue);
        }
        if ((currentValue = this.cifOutputMergesBoxes.isSelected()) != IOTool.isCIFOutMergesBoxes()) {
            IOTool.setCIFOutMergesBoxes(currentValue);
        }
        if ((currentValue = this.cifOutputInstantiatesTopLevel.isSelected()) != IOTool.isCIFOutInstantiatesTopLevel()) {
            IOTool.setCIFOutInstantiatesTopLevel(currentValue);
        }
        if ((currentValue = this.cifInputSquaresWires.isSelected()) != IOTool.isCIFInSquaresWires()) {
            IOTool.setCIFInSquaresWires(currentValue);
        }
    }

    private void initComponents() {
        this.cif = new JPanel();
        this.jLabel1 = new JLabel();
        this.cifLayers = new JScrollPane();
        this.cifOutputMimicsDisplay = new JCheckBox();
        this.cifOutputMergesBoxes = new JCheckBox();
        this.cifOutputInstantiatesTopLevel = new JCheckBox();
        this.cifInputSquaresWires = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.cifLayer = new JTextField();
        this.jPanel1 = new JPanel();
        this.cifTechnology = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CIFTab.this.closeDialog(evt);
            }
        });
        this.cif.setLayout(new GridBagLayout());
        this.jLabel1.setText("CIF Layer:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.cif.add((Component)this.jLabel1, gridBagConstraints);
        this.cifLayers.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.cif.add((Component)this.cifLayers, gridBagConstraints);
        this.cifOutputMimicsDisplay.setText("Output Mimics Display");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.cif.add((Component)this.cifOutputMimicsDisplay, gridBagConstraints);
        this.cifOutputMergesBoxes.setText("Output Merges Boxes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.cif.add((Component)this.cifOutputMergesBoxes, gridBagConstraints);
        this.cifOutputInstantiatesTopLevel.setText("Output Instantiates Top Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        this.cif.add((Component)this.cifOutputInstantiatesTopLevel, gridBagConstraints);
        this.cifInputSquaresWires.setText("Input Squares Wires");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.cif.add((Component)this.cifInputSquaresWires, gridBagConstraints);
        this.jLabel2.setText("(time consuming)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.cif.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.cif.add((Component)this.cifLayer, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.cif.add((Component)this.jPanel1, gridBagConstraints);
        this.cifTechnology.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.cif.add((Component)this.cifTechnology, gridBagConstraints);
        this.getContentPane().add((Component)this.cif, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class CIFDocumentListener
    implements DocumentListener {
        CIFTab dialog;

        CIFDocumentListener(CIFTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }
    }
}

