/* translation of file "petrinet-patterns-basic.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_basic

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-basic.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 23 "petrinet-patterns-basic.k"
/*!
 * \file    petrinet-patterns-basic.cc
 *
 * \brief   Petri net patterns for BPEL's basic activities
 *
 *          This file implements the patterns for BPEL's basic activities,
 *          namely:
 *            - <empty>
 *            - <invoke> (asynchronous and synchronous)
 *            - <receive>
 *            - <reply>
 *            - <assign>
 *            - <validate>
 *            - <wait> (deadline and duration)
 *            - <throw>
 *            - <rethrow>
 *            - <exit>
 *            - <compensate>
 *            - <compensateScope>
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          Christian Gierds <gierds@informatik.hu-berlin.de>,
 *          last changes of: \$Author: nielslohmann $ 
 * 
 * \since   2006-11-26
 *
 * \date    \$Date: 2007/06/07 10:53:43 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file
 *          petrinet-patterns-basic.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.55 $
 */

#line  54 "petrinet-patterns-basic.cc"
#line 74 "petrinet-patterns-basic.k"
#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"
#include "extension-chor.h"

extern PetriNet PN;

#line  66 "petrinet-patterns-basic.cc"
#line 93 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PEmpty(impl_tEmpty *abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <empty> activity.
 *
 *          \image html "empty.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  81 "petrinet-patterns-basic.cc"
#line 147 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::POpaqueActivity(impl_tOpaqueActivity *abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <opaqueActivity> activity.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    This is the same pattern as used for the <empty> activity.
 *
 * \ingroup patterns
 */

#line  96 "petrinet-patterns-basic.cc"
#line 204 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PAsynchronousInvoke(impl_tInvoke* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for asynchronous <invoke> activity.
 *
 *          \image html "invoke_a.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  111 "petrinet-patterns-basic.cc"
#line 308 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PSynchronousInvoke(impl_tInvoke* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the synchronous <invoke> activity.
 *
 *          \image html "invoke_s.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  126 "petrinet-patterns-basic.cc"
#line 412 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PReceive(impl_tReceive* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <receive> activity.
 * 
 *          \image html "receive.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  141 "petrinet-patterns-basic.cc"
#line 522 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PReply(impl_tReply* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <reply> activity.
 *
 *          \image html "reply.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  156 "petrinet-patterns-basic.cc"
#line 624 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PAssign(impl_tAssign* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <assign> activity.
 *
 *          \image html "assign.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 * 
 * \todo    Overwork this pattern and adjust it to the new semantics.
 */

#line  173 "petrinet-patterns-basic.cc"
#line 764 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PValidate(impl_tValidate* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <validate> activity.
 *
 *          \image html "validate.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 *
 * \todo    Overwork this pattern and connect it with the respective variable.
 */

#line  190 "petrinet-patterns-basic.cc"
#line 856 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PWait(impl_tWait* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <wait> activity.
 *
 *          \image html "wait.png" "pattern"
 *
 *          As we do not model time, the <wait> pattern is modeled by the
 *          pattern of the <empty> activity.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  208 "petrinet-patterns-basic.cc"
#line 913 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PThrow(impl_tThrow* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <throw> activity.
 *
 *          \image html "throw.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    This pattern is replaced by an <empty> activity in the
 *          "communicationonly" patterns.
 *
 * \ingroup patterns
 *
 * \todo    Handle the outgoing links of the throw activity. Right now, they
 *          are not set at all.
 */

#line  229 "petrinet-patterns-basic.cc"
#line 996 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PRethrow(impl_tRethrow* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <rethrow> activity.
 *
 *          \image html "rethrow.png" "pattern"
 * 
 *          The gray place is from the <faultHandlers> pattern.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 *
 * \todo    
 *          - Check whether this pattern should also use the "throwFault"
 *            function.
 *          - Handle the outgoing links of the throw activity. Right now, they
 *            are not set at all.
 */

#line  252 "petrinet-patterns-basic.cc"
#line 1060 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PExit(impl_tExit* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <exit> activity.
 * 
 *          \image html "exit.png" "pattern"
 *          
 *          The gray places are from the <process> pattern.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    The patterns for <exit> activity (WS-BPEL 2.0) and the <terminate>
 *          activity (BPEL4WS 1.1) are the same.
 *
 * \note    This pattern is replaced by an <empty> activity in the
 *          "communicationonly" patterns.
 *
 * \ingroup patterns
 */

#line  275 "petrinet-patterns-basic.cc"
#line 1146 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PCompensate(impl_tCompensate* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <compensate> activity.
 *          
 *          \image html "compensate.png" "pattern"
 *
 *          The gray places are from the child <scope> patterns.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    This pattern is replaced by an <empty> activity in the
 *          "communicationonly" patterns.
 *
 * \ingroup patterns
 */

#line  295 "petrinet-patterns-basic.cc"
#line 1260 "petrinet-patterns-basic.k"
/*!
 * \fn      void kc::PCompensateScope(impl_tCompensate* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <compensateScope> activity.
 *
 *          \image html "compensatescope.png" "pattern"
 *
 *          The gray places are from the target <scope> pattern.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    The <compensate scope="a"> activity of BPEL4WS 1.1 has been
 *          replaced by a <compensateScope target="a"> activity during parsing.
 *
 * \note    This pattern is replaced by an <empty> activity in the
 *          "communicationonly" patterns.
 *
 * \ingroup patterns
 */

#line  318 "petrinet-patterns-basic.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void PEmpty(impl_tEmpty *abstract_phylum, uview current_view)
#line 107 "petrinet-patterns-basic.k"
{
    impl_tEmpty_Empty* phylum = static_cast<impl_tEmpty_Empty*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";  


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    Transition *t1 = PN.newTransition(prefix + "empty");
    PN.newArc(p1, t1);
    PN.newArc(t1, p2);


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");
	Transition *t2 = stop(p1, "initial", prefix);
	Transition *t3 = stop(p2, "final", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 136 "petrinet-patterns-basic.k"
}
#line  362 "petrinet-patterns-basic.cc"

void POpaqueActivity(impl_tOpaqueActivity *abstract_phylum, uview current_view)
#line 161 "petrinet-patterns-basic.k"
{
    impl_tOpaqueActivity_OpaqueActivity* phylum = static_cast<impl_tOpaqueActivity_OpaqueActivity*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";  


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    Transition *t1 = PN.newTransition(prefix + "opaqueActivity");
    PN.newArc(p1, t1);
    PN.newArc(t1, p2);


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");
	Transition *t2 = stop(p1, "initial", prefix);
	Transition *t3 = stop(p2, "final", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 190 "petrinet-patterns-basic.k"
}
#line  398 "petrinet-patterns-basic.cc"

void PAsynchronousInvoke(impl_tInvoke *abstract_phylum, uview current_view)
#line 218 "petrinet-patterns-basic.k"
{
    impl_tInvoke_AsynchronousInvoke* phylum =
    static_cast<impl_tInvoke_AsynchronousInvoke*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    ASTE *myself = globals::ASTEmap[phylum->id];
    assert(myself != NULL);

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "faulted");


	    sendingTransition("invoke", p1, p2,
		PN.findPlace("out." + myself->channelName),
		p5, prefix, mkinteger(phylum->id),
		myself->controlFlow);


	    Transition *t2 = stop(p1, "initial", prefix);
	    Transition *t3 = stop(p2, "final", prefix);
	    Transition *t4 = stop(p5, "faulted", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");


	    string interface_place_name = "out." + myself->channelName;


	    if (globals::instances_of_current_process == 0 &&
		myself->messageLink != NULL &&
		(myself->messageLink->receiver_is_iterator ||
		    myself->messageLink->sender_is_iterator ||
		    myself->messageLink->sender_is_unique))
	    {
		interface_place_name += ".instance_" + toString(myself->channel_instances++);
	    }


	    if (myself->messageLink != NULL &&
		myself->messageLink->receiver_is_unique)
	    {
		for (unsigned int i = 1; i <= myself->messageLink->participantSet->count; i++)
		{
		    Transition *t1 = PN.newTransition(prefix + "invoke" + toString(i));
		    PN.newArc(t1, PN.findPlace(interface_place_name + ".instance_" + toString(i)));
		    PN.newArc(p1, t1);
		    PN.newArc(t1, p2);          
		}
	    }
	    else
	    {

		Transition *t1 = PN.newTransition(prefix + "invoke");
		PN.newArc(t1, PN.findPlace(interface_place_name));
		PN.newArc(p1, t1);
		PN.newArc(t1, p2);
	    }

	    break;
	}

	default: {  }      
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 304 "petrinet-patterns-basic.k"
}
#line  491 "petrinet-patterns-basic.cc"

void PSynchronousInvoke(impl_tInvoke *abstract_phylum, uview current_view)
#line 322 "petrinet-patterns-basic.k"
{
    impl_tInvoke_SynchronousInvoke* phylum =
    static_cast<impl_tInvoke_SynchronousInvoke*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    ASTE *myself = globals::ASTEmap[phylum->id];
    assert(myself != NULL);

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "final");
	    Place *p4 = PN.newPlace(prefix + "stop");
	    Place *p5 = PN.newPlace(prefix + "stopped");
	    Place *p6 = PN.newPlace(prefix + "faulted");


	    string interface_place_name = "out." + myself->channelName;


	    string interface_place_name2 = "in." + myself->channelName2;


	    sendingTransition("invoke_out",  p1, p2,
		PN.findPlace(interface_place_name),
		p6, prefix, mkinteger(phylum->id),
		myself->controlFlow);


	    receivingTransition("invoke_in", p2, p3,
		PN.findPlace(interface_place_name2),
		p6, prefix, mkinteger(phylum->id),
		myself->controlFlow);


	    Transition *t3 = stop(p1, "initial", prefix);
	    Transition *t4 = stop(p2, "running", prefix);
	    Transition *t5 = stop(p3, "final", prefix);
	    Transition *t6 = stop(p6, "faulted", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "final");


	    Transition *t1 = PN.newTransition(prefix + "invokeO");
	    PN.newArc(t1, PN.findPlace("out." + myself->channelName));
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);


	    Transition *t2 = PN.newTransition(prefix + "invokeI");
	    PN.newArc(PN.findPlace("in." + myself->channelName2), t2);
	    PN.newArc(p2, t2);
	    PN.newArc(t2, p3);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 401 "petrinet-patterns-basic.k"
}
#line  577 "petrinet-patterns-basic.cc"

void PReceive(impl_tReceive *abstract_phylum, uview current_view)
#line 426 "petrinet-patterns-basic.k"
{
    impl_tReceive_Receive* phylum =
    static_cast<impl_tReceive_Receive*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    ASTE *myself = globals::ASTEmap[phylum->id];
    assert(myself != NULL);

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "faulted");


	    receivingTransition("receive", p1, p2,
		PN.findPlace("in." + myself->channelName),
		p5, prefix, mkinteger(phylum->id),
		myself->controlFlow);


	    Transition *t2 = stop(p1, "initial", prefix);
	    Transition *t3 = stop(p2, "final", prefix);
	    Transition *t4 = stop(p5, "faulted", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");


	    string interface_place_name = "in." + myself->channelName;


	    if (globals::instances_of_current_process == 0 &&
		myself->messageLink != NULL &&
		(myself->messageLink->receiver_is_iterator ||
		    myself->messageLink->sender_is_iterator ||
		    myself->messageLink->receiver_is_unique))
	    {
		interface_place_name += ".instance_" + toString(myself->channel_instances++);
	    }


	    if (myself->messageLink != NULL &&
		myself->messageLink->sender_is_unique)
	    {
		for (unsigned int i = 1; i <= myself->messageLink->participantSet->count; i++)
		{
		    Transition *t1 = PN.newTransition(prefix + "receive" + toString(i));
		    PN.newArc(PN.findPlace(interface_place_name + ".instance_" + toString(i)), t1);
		    PN.newArc(p1, t1);
		    PN.newArc(t1, p2);          
		}
	    }
	    else
	    {

		Transition *t1 = PN.newTransition(prefix + "receive");
		PN.newArc(PN.findPlace(interface_place_name), t1);
		PN.newArc(p1, t1);
		PN.newArc(t1, p2);
	    }

	    break;
	}

	default: {  }      
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);      

#line 512 "petrinet-patterns-basic.k"
}
#line  670 "petrinet-patterns-basic.cc"

void PReply(impl_tReply *abstract_phylum, uview current_view)
#line 536 "petrinet-patterns-basic.k"
{
    impl_tReply_Reply* phylum = static_cast<impl_tReply_Reply*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";  

    ASTE *myself = globals::ASTEmap[phylum->id];
    assert(myself != NULL);

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "faulted");


	    sendingTransition("reply", p1, p2,
		PN.findPlace("out." + myself->channelName),
		p5, prefix, mkinteger(phylum->id),
		myself->controlFlow);


	    Transition *t2 = stop(p1, "initial", prefix);
	    Transition *t3 = stop(p2, "final", prefix);
	    Transition *t4 = stop(p5, "faulted", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");


	    string interface_place_name = "out." + myself->channelName;
	    if (myself->messageLink != NULL &&
		myself->messageLink->receiver_is_iterator)
	    interface_place_name += ".instance_" + toString(myself->channel_instances++);


	    if (myself->messageLink != NULL &&
		myself->messageLink->receiver_is_unique)
	    {
		for (unsigned int i = 1; i <= myself->messageLink->participantSet->count; i++)
		{
		    Transition *t1 = PN.newTransition(prefix + "reply" + toString(i));
		    PN.newArc(t1, PN.findPlace(interface_place_name + ".instance_" + toString(i)));
		    PN.newArc(p1, t1);
		    PN.newArc(t1, p2);
		}
		break;
	    }


	    Transition *t1 = PN.newTransition(prefix + "reply");
	    PN.newArc(t1, PN.findPlace(interface_place_name));
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }      
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 613 "petrinet-patterns-basic.k"
}
#line  754 "petrinet-patterns-basic.cc"

void PAssign(impl_tAssign *abstract_phylum, uview current_view)
#line 640 "petrinet-patterns-basic.k"
{
    impl_tAssign_Assign* phylum =
    static_cast<impl_tAssign_Assign*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";


    switch (current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p3 = PN.newPlace(prefix + "final");
	    Place *p5 = PN.newPlace(prefix + "stop");
	    Place *p6 = PN.newPlace(prefix + "stopped");

	    Transition *t4 = stop(p1, "initial", prefix);
	    Transition *t7 = stop(p3, "final", prefix);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

	    int copyCount = 1;
	    Place *lastPlace = PN.findPlace(prefix + "initial");

	    {
#line 668 "petrinet-patterns-basic.k"
		tCopy_list kc_fe_selvar_1 =  phylum->tCopy_list_1;

#line  790 "petrinet-patterns-basic.cc"
		while(
			kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
		    ) {
		    tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
		    {
#line 668 "petrinet-patterns-basic.k"
			{
#line 669 "petrinet-patterns-basic.k"
			    if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 669 "petrinet-patterns-basic.k"
#line 668 "petrinet-patterns-basic.k"
				const tCopy copyBlock = kc_selvar_0_1;
#line 668 "petrinet-patterns-basic.k"
				const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 668 "petrinet-patterns-basic.k"
				const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 669 "petrinet-patterns-basic.k"

				string newPrefix = prefix + "copy." + toString(copyCount) + ".";

				if (globals::ASTEmap[from->id]->variableName != "")
				{
				    Place *p2 = PN.newPlace(newPrefix + "running");
				    Place *p4 = PN.newPlace(newPrefix + "p4");
				    Place *p8 = PN.newPlace(newPrefix + "final");

				    Transition *t1 = PN.newTransition(newPrefix + "t1");
				    PN.newArc(lastPlace, t1);
				    PN.newArc(t1, p2);
				    if (globals::parameters[P_VARIABLES])
				    PN.newArc(PN.findPlace("variable." + globals::ASTEmap[from->id]->variableName), t1, READ);

				    Transition *t2 = PN.newTransition(newPrefix + "t2");
				    PN.newArc(p2, t2);
				    PN.newArc(t2, p8);
				    if (globals::parameters[P_VARIABLES])
				    {
					PN.newArc(PN.findPlace("variable." + globals::ASTEmap[to->id]->variableName), t2);
					PN.newArc(t2, PN.findPlace("variable." + globals::ASTEmap[to->id]->variableName));
				    }


				    if (globals::parameters[P_STANDARDFAULTS])
				    Transition *t3 = throwFault(p2, p4, "running", newPrefix,
					mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);

				    Transition *t6 = stop(p4, "p4at" + toString(copyCount), prefix);

				    lastPlace = p8;
				}
				else
				{
				    Place *p4 = PN.newPlace(newPrefix + "p4");
				    Place *p8 = PN.newPlace(newPrefix + "final");

				    Transition *t2 = PN.newTransition(newPrefix + "t2");
				    PN.newArc(lastPlace, t2);
				    PN.newArc(t2, p8);
				    if (globals::parameters[P_VARIABLES])
				    {
					PN.newArc(PN.findPlace("variable." + globals::ASTEmap[to->id]->variableName), t2);
					PN.newArc(t2, PN.findPlace("variable." + globals::ASTEmap[to->id]->variableName));
				    }


				    if (globals::parameters[P_STANDARDFAULTS])
				    Transition *t3 = throwFault(lastPlace, p4, "initial", newPrefix,
					mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);

				    Transition *t6 = stop(p4, "p4at" + toString(copyCount), prefix);

				    lastPlace = p8;
				}

				copyCount++;

#line  867 "petrinet-patterns-basic.cc"
			    } else
			    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			}

#line  872 "petrinet-patterns-basic.cc"
		    }
		    kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 668 "petrinet-patterns-basic.k"

#line  877 "petrinet-patterns-basic.cc"
		}
	    }
#line 728 "petrinet-patterns-basic.k"

	    PN.mergePlaces(prefix + "final", lastPlace);
	    break;
	}

	case (petrinetsmall_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");

	    Transition *t1 = PN.newTransition(prefix + "assign");

	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

	    break;
	}

	default: {  }
    }

    footer(phylum->id);

#line 753 "petrinet-patterns-basic.k"
}
#line  909 "petrinet-patterns-basic.cc"

void PValidate(impl_tValidate *abstract_phylum, uview current_view)
#line 780 "petrinet-patterns-basic.k"
{
    impl_tValidate_Validate* phylum =
    static_cast<impl_tValidate_Validate*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    switch (current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "final");
	    Place *p4 = PN.newPlace(prefix + "stop");
	    Place *p5 = PN.newPlace(prefix + "stopped");
	    Place *p6 = PN.newPlace(prefix + "faulted");

	    Transition *t1 = PN.newTransition(prefix + "read_variable");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    Transition *t2 = PN.newTransition(prefix + "continue");
	    PN.newArc(p2, t2);
	    PN.newArc(t2, p3);


	    if (globals::parameters[P_STANDARDFAULTS])
	    {
		Transition *t3 = throwFault(p2, p6, "running", prefix,
		    mkinteger(phylum->id),
		    globals::ASTEmap[phylum->id]->controlFlow);
	    }


	    Transition *t4 = stop(p1, "initial", prefix);
	    Transition *t5 = stop(p2, "running", prefix);
	    Transition *t6 = stop(p3, "final", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");


	    Transition *t1 = PN.newTransition(prefix + "validate");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 845 "petrinet-patterns-basic.k"
}
#line  981 "petrinet-patterns-basic.cc"

void PWait(impl_tWait *abstract_phylum, uview current_view)
#line 873 "petrinet-patterns-basic.k"
{
    impl_tWait_Wait* phylum = static_cast<impl_tWait_Wait*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    Transition *t1 = PN.newTransition(prefix + "wait");
    PN.newArc(p1, t1);
    PN.newArc(t1, p2);


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");
	Transition *t2 = stop(p1, "initial", prefix);
	Transition *t3 = stop(p2, "final", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);      

#line 902 "petrinet-patterns-basic.k"
}
#line  1017 "petrinet-patterns-basic.cc"

void PThrow(impl_tThrow *abstract_phylum, uview current_view)
#line 933 "petrinet-patterns-basic.k"
{
    impl_tThrow_Throw* phylum = static_cast<impl_tThrow_Throw*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";
    assert(globals::ASTEmap[phylum->id] != NULL);

    switch(current_view)
    {
	case(petrinetnew_enum):
	{



	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "faulted");
	    Place *p4 = PN.newPlace(prefix + "stop");
	    Place *p5 = PN.newPlace(prefix + "stopped");
	    Place *p6 = PN.newPlace(prefix + "final");


	    Transition *t1 = throwFault(p1, p2, "throw", prefix,
		mkinteger(phylum->id),
		globals::ASTEmap[phylum->id]->controlFlow);


	    Transition *t2 = stop(p1, "initial", prefix);
	    Transition *t3 = stop(p2, "faulted", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Transition *t1 = PN.newTransition(prefix + "empty");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);      

#line 985 "petrinet-patterns-basic.k"
}
#line  1076 "petrinet-patterns-basic.cc"

void PRethrow(impl_tRethrow *abstract_phylum, uview current_view)
#line 1018 "petrinet-patterns-basic.k"
{
    impl_tRethrow_Rethrow* phylum =
    static_cast<impl_tRethrow_Rethrow*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "faulted");
    Place *p4 = PN.newPlace(prefix + "stop");
    Place *p5 = PN.newPlace(prefix + "stopped");
    Place *p6 = PN.newPlace(prefix + "final");


    Transition *t1 = throwFault(p1, p2, "rethrow", prefix,
	mkinteger(phylum->id),
	globals::ASTEmap[phylum->id]->controlFlow);

    PN.newArc(PN.findPlace(toString(globals::ASTEmap[phylum->id]->parentScopeId) +
	    ".faultHandlers.fault"), t1, READ);


    Transition *t2 = stop(p1, "initial", prefix);
    Transition *t3 = stop(p2, "faulted", prefix);


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 1049 "petrinet-patterns-basic.k"
}
#line  1114 "petrinet-patterns-basic.cc"

void PExit(impl_tExit *abstract_phylum, uview current_view)
#line 1082 "petrinet-patterns-basic.k"
{
    impl_tExit_Exit* phylum = static_cast<impl_tExit_Exit*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    switch(current_view)
    {
	case(petrinetnew_enum):
	{


	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "done");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "final");


	    Transition *t1 = PN.newTransition(prefix + "exit");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);
	    PN.newArc(PN.findPlace("1.internal.!Exiting"), t1);
	    PN.newArc(t1, PN.findPlace("1.internal.Exiting"));
	    PN.newArc(t1, PN.findPlace("1.internal.inner_stop"));


	    Transition *t2 = stop(p1, "initial", prefix);
	    Transition *t3 = stop(p2, "done", prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Transition *t1 = PN.newTransition(prefix + "empty");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 1135 "petrinet-patterns-basic.k"
}
#line  1174 "petrinet-patterns-basic.cc"

void PCompensate(impl_tCompensate *abstract_phylum, uview current_view)
#line 1165 "petrinet-patterns-basic.k"
{
    impl_tCompensate_Compensate* phylum =
    static_cast<impl_tCompensate_Compensate*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "compensating");


	    Transition *t1 = PN.newTransition(prefix + "call_ch");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p5);


	    Transition *t2 = PN.newTransition(prefix + "finish");
	    PN.newArc(p5, t2);
	    PN.newArc(t2, p2);

	    Transition *t3 = NULL;
	    Transition *t4 = NULL;

	    unsigned int parentId = globals::ASTEmap[ phylum->id ]->parentScopeId;
	    if ( !globals::ASTEmap[ parentId ]->enclosedScopes.empty() )
	    {

		t3 = PN.newTransition(prefix + "stop_ch");
		PN.newArc(p3, t3);
		PN.newArc(p5, t3, READ);


		t4 = PN.newTransition(prefix + "ch_stopped");
		PN.newArc(p5, t4);
		PN.newArc(t4, p4);
	    }


	    Transition *t5 = stop(p1, "initial", prefix);
	    Transition *t6 = stop(p2, "final",   prefix);


	    for( set< unsigned int >::iterator scope = globals::ASTEmap[ parentId ]->enclosedScopes.begin();
		scope != globals::ASTEmap[ parentId ]->enclosedScopes.end();
		scope++ )
	    {
		string newPrefix = toString(*scope) + ".internal.";
		PN.newArc(t1, PN.findPlace(newPrefix + "compensate"));
		PN.newArc(t3, PN.findPlace(newPrefix + "ch_stop"));
		PN.newArc(PN.findPlace(newPrefix + "ch_stopped"),  t4);
		PN.newArc(PN.findPlace(newPrefix + "compensated"), t2);
	    }

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Transition *t1 = PN.newTransition(prefix + "empty");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 1249 "petrinet-patterns-basic.k"
}
#line  1265 "petrinet-patterns-basic.cc"

void PCompensateScope(impl_tCompensate *abstract_phylum, uview current_view)
#line 1282 "petrinet-patterns-basic.k"
{
    impl_tCompensate_CompensateScope* phylum =
    static_cast<impl_tCompensate_CompensateScope*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id);
    string prefix = toString(phylum->id) + ".internal.";

    switch(current_view)
    {
	case(petrinetnew_enum):
	{

	    string newPrefix =
	    toString(globals::ASTE_scopeNames[globals::ASTEmap[phylum->id]->attributes["target"]]) + ".internal.";


	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "compensating");


	    Transition *t1 = PN.newTransition(prefix + "call_ch");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p5);
	    PN.newArc(t1, PN.findPlace(newPrefix + "compensate"));


	    Transition *t2 = PN.newTransition(prefix + "finish");
	    PN.newArc(p5, t2);
	    PN.newArc(t2, p2);
	    PN.newArc(PN.findPlace(newPrefix + "compensated"), t2);


	    Transition *t3 = PN.newTransition(prefix + "stop_ch");
	    PN.newArc(p3, t3);
	    PN.newArc(p5, t3, READ);
	    PN.newArc(t3, PN.findPlace(newPrefix + "ch_stop"));


	    Transition *t4 = PN.newTransition(prefix + "ch_stopped");
	    PN.newArc(p5, t4);
	    PN.newArc(t4, p4);
	    PN.newArc(PN.findPlace(newPrefix + "ch_stopped"),  t4);


	    Transition *t5 = stop(p1, "initial", prefix);
	    Transition *t6 = stop(p2, "final",   prefix);

	    break;
	}

	case(petrinetsmall_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Transition *t1 = PN.newTransition(prefix + "empty");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    break;
	}

	default: {  }
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);

    footer(phylum->id);

#line 1355 "petrinet-patterns-basic.k"
}
#line  1345 "petrinet-patterns-basic.cc"


} // namespace kc
