/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (bsort-opt.c)
 *  
 *  It has been AutoGen-ed  Saturday September 21, 2002 at 03:30:08 PM PDT
 *  From the definitions    ./bsort-opt.def
 *  and the template file   options
 */
#include "bsort-opt.h"

tSCC zCopyright[] =
       "blocksort copyright (c) 1998-2002 Bruce Korb, all rights reserved";
tSCC zCopyrightNotice[] =
       "blocksort is free software copyrighted by Bruce Korb.\n\n\
Redistribution and use in source and binary forms, with or without\n\
modification, are permitted provided that the following conditions\n\
are met:\n\
1. Redistributions of source code must retain the above copyright\n\
   notice, this list of conditions and the following disclaimer.\n\
2. Redistributions in binary form must reproduce the above copyright\n\
   notice, this list of conditions and the following disclaimer in the\n\
   documentation and/or other materials provided with the distribution.\n\
3. Neither the name ``Bruce Korb'' nor the name of any other\n\
   contributor may be used to endorse or promote products derived\n\
   from this software without specific prior written permission.\n\n\
blocksort IS PROVIDED BY Bruce Korb ``AS IS'' AND ANY EXPRESS\n\
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n\
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n\
ARE DISCLAIMED.  IN NO EVENT SHALL Bruce Korb OR ANY OTHER CONTRIBUTORS\n\
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n\
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n\
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n\
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n\
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n\
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\n\
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

extern tUsageProc optionUsage;


/*
 *  global included definitions
 */
#include "system.h"

#ifndef NULL
#  define NULL 0
#endif
#ifndef EXIT_SUCCESS
#  define  EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#  define  EXIT_FAILURE 1
#endif
/*
 *  Syntax option description:
 */
tSCC    zSyntaxText[] =
        "EXTENDED, ICASE or NEWLINE (see regcomp(3))";
tSCC    zSyntax_NAME[]             = "SYNTAX";
#define zNotSyntax_Pfx               NULL
#define zNotSyntax_Name              NULL
tSCC    zSyntax_Name[]             = "syntax";
#define SYNTAX_FLAGS       (OPTST_STACKED | OPTST_DISABLED | OPTST_INIT)

/*
 *  Cook option description:
 */
tSCC    zCookText[] =
        "process escaped characters";
tSCC    zCook_NAME[]               = "COOK";
tSCC    zNotCook_Name[]            = "no-cook";
tSCC    zNotCook_Pfx[]             = "no";
#define zCook_Name                   (zNotCook_Name + 3)
#define COOK_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Pattern option description:
 */
tSCC    zPatternText[] =
        "File Segmentation Pattern";
tSCC    zPattern_NAME[]            = "PATTERN";
#define zNotPattern_Pfx              NULL
#define zNotPattern_Name             NULL
tSCC    zPattern_Name[]            = "pattern";
#define PATTERN_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Input option description:
 */
tSCC    zInputText[] =
        "Input File";
tSCC    zInput_NAME[]              = "INPUT";
#define zNotInput_Pfx                NULL
#define zNotInput_Name               NULL
tSCC    zInput_Name[]              = "input";
#define INPUT_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Output option description:
 */
tSCC    zOutputText[] =
        "Output File";
tSCC    zOutput_NAME[]             = "OUTPUT";
#define zNotOutput_Pfx               NULL
#define zNotOutput_Name              NULL
tSCC    zOutput_Name[]             = "output";
#define OUTPUT_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Key option description:
 */
tSCC    zKeyText[] =
        "Sort Key Finding Pattern";
tSCC    zKey_NAME[]                = "KEY";
#define zNotKey_Pfx                  NULL
#define zNotKey_Name                 NULL
tSCC    zKey_Name[]                = "key";
#define KEY_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Trailer option description:
 */
tSCC    zTrailerText[] =
        "Trailer Finding Pattern";
tSCC    zTrailer_NAME[]            = "TRAILER";
#define zNotTrailer_Pfx              NULL
#define zNotTrailer_Name             NULL
tSCC    zTrailer_Name[]            = "trailer";
#define TRAILER_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Start option description:
 */
tSCC    zStartText[] =
        "Starting Point Pattern";
tSCC    zStart_NAME[]              = "START";
#define zNotStart_Pfx                NULL
#define zNotStart_Name               NULL
tSCC    zStart_Name[]              = "start";
#define START_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Spacing option description:
 */
tSCC    zSpacingText[] =
        "blank line count between sections";
tSCC    zSpacing_NAME[]            = "SPACING";
#define zNotSpacing_Pfx              NULL
#define zNotSpacing_Name             NULL
tSCC    zSpacing_Name[]            = "spacing";
#define SPACING_FLAGS       (OPTST_NUMERIC | OPTST_DISABLED | OPTST_INIT)

/*
 *  Verbose option description:
 */
tSCC    zVerboseText[] =
        "Display extra information";
tSCC    zVerbose_NAME[]            = "VERBOSE";
#define zNotVerbose_Pfx              NULL
#define zNotVerbose_Name             NULL
tSCC    zVerbose_Name[]            = "verbose";
#define VERBOSE_FLAGS       (OPTST_DISABLED | OPTST_INIT)

/*
 *  Help option description:
 */
tSCC zHelpText[]  = "Display usage information and exit";
tSCC zHelp_Name[] = "help";

/*
 *  More_Help option description:
 */
tSCC zMore_HelpText[]  = "Extended usage information passed thru pager";
tSCC zMore_Help_Name[] = "more-help";

/*
 *  Version option description:
 */
tSCC zVersionText[]    = "Output version information and exit";
tSCC zVersion_Name[]   = "version";
/*
 *  Procedures to call when option(s) are encountered
 */
static tOptProc doOptPattern;
static tOptProc doOptInput;
static tOptProc doOptOutput;

/*
 *  These are always callable, whether
 *  TEST_BLOCKSORT_OPTS is defined or not
 */
static tOptProc doUsageOpt;
extern  tOptProc  doVersion;
#define DOVERPROC doVersion
extern tOptProc doPagedUsage;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Blocksort Option Descriptions.
 */
static tOptDesc optDesc[ OPTION_CT ] = {
  {  /* entry idx, value */ 0, VALUE_OPT_SYNTAX,
     /* equiv idx, value */ 0, VALUE_OPT_SYNTAX,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 3, 0,
     /* opt state flags  */ SYNTAX_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ stackOptArg,
     /* desc, NAME, name */ zSyntaxText,  zSyntax_NAME,
                            zSyntax_Name,
     /* disablement strs */ zNotSyntax_Name, zNotSyntax_Pfx },

  {  /* entry idx, value */ 1, VALUE_OPT_COOK,
     /* equiv idx, value */ 1, VALUE_OPT_COOK,
     /* option argument  */ ARG_NONE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 4, 0,
     /* opt state flags  */ COOK_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zCookText,  zCook_NAME,
                            zCook_Name,
     /* disablement strs */ zNotCook_Name, zNotCook_Pfx },

  {  /* entry idx, value */ 2, VALUE_OPT_PATTERN,
     /* equiv idx, value */ 2, VALUE_OPT_PATTERN,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ PATTERN_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPattern,
     /* desc, NAME, name */ zPatternText,  zPattern_NAME,
                            zPattern_Name,
     /* disablement strs */ zNotPattern_Name, zNotPattern_Pfx },

  {  /* entry idx, value */ 3, VALUE_OPT_INPUT,
     /* equiv idx, value */ 3, VALUE_OPT_INPUT,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ INPUT_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptInput,
     /* desc, NAME, name */ zInputText,  zInput_NAME,
                            zInput_Name,
     /* disablement strs */ zNotInput_Name, zNotInput_Pfx },

  {  /* entry idx, value */ 4, VALUE_OPT_OUTPUT,
     /* equiv idx, value */ 4, VALUE_OPT_OUTPUT,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OUTPUT_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptOutput,
     /* desc, NAME, name */ zOutputText,  zOutput_NAME,
                            zOutput_Name,
     /* disablement strs */ zNotOutput_Name, zNotOutput_Pfx },

  {  /* entry idx, value */ 5, VALUE_OPT_KEY,
     /* equiv idx, value */ 5, VALUE_OPT_KEY,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ KEY_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPattern,
     /* desc, NAME, name */ zKeyText,  zKey_NAME,
                            zKey_Name,
     /* disablement strs */ zNotKey_Name, zNotKey_Pfx },

  {  /* entry idx, value */ 6, VALUE_OPT_TRAILER,
     /* equiv idx, value */ 6, VALUE_OPT_TRAILER,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ TRAILER_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPattern,
     /* desc, NAME, name */ zTrailerText,  zTrailer_NAME,
                            zTrailer_Name,
     /* disablement strs */ zNotTrailer_Name, zNotTrailer_Pfx },

  {  /* entry idx, value */ 7, VALUE_OPT_START,
     /* equiv idx, value */ 7, VALUE_OPT_START,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ START_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPattern,
     /* desc, NAME, name */ zStartText,  zStart_NAME,
                            zStart_Name,
     /* disablement strs */ zNotStart_Name, zNotStart_Pfx },

  {  /* entry idx, value */ 8, VALUE_OPT_SPACING,
     /* equiv idx, value */ 8, VALUE_OPT_SPACING,
     /* option argument  */ ARG_MUST,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SPACING_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ zSpacingText,  zSpacing_NAME,
                            zSpacing_Name,
     /* disablement strs */ zNotSpacing_Name, zNotSpacing_Pfx },

  {  /* entry idx, value */ 9, VALUE_OPT_VERBOSE,
     /* equiv idx, value */ 9, VALUE_OPT_VERBOSE,
     /* option argument  */ ARG_NONE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERBOSE_FLAGS,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zVerboseText,  zVerbose_NAME,
                            zVerbose_Name,
     /* disablement strs */ zNotVerbose_Name, zNotVerbose_Pfx },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* option argument  */ ARG_MAY,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max act ct  */ 0, 1, 0,
     /* opt state flags  */ OPTST_INIT,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ DOVERPROC,
     /* desc, NAME, name */ zVersionText, NULL, zVersion_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* option argument  */ ARG_NONE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max act ct  */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ zHelpText, NULL, zHelp_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* option argument  */ ARG_NONE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max act ct  */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ doPagedUsage,
     /* desc, NAME, name */ zMore_HelpText, NULL, zMore_Help_Name,
     /* disablement strs */ NULL, NULL }
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Blocksort Option Environment
 */
tSCC   zPROGNAME[]   = "BLOCKSORT";
tSCC   zUsageTitle[] =
"blocksort - Sort Blocks of Text - Ver. 1.4\n\
USAGE:  %s { <option-name>[{=| }<val>] }...\n";
#define zRcName     NULL
#define apzHomeList NULL

tSCC   zBugsAddr[]    = "autogen-bugs@sf.net";
tSCC   zExplain[]     = "\n\
Given a search pattern, this program will segment a file on the\n\
start of every line that matches a pattern.  Each block of text\n\
is then lexicographically sorted and reassembled into the output.\n\
Any text found before the first match will be left in place.\n\
If \"KEY\" is supplied, the sort is based on the matching text.\n\
If \"KEY\" contains subexpressions, then the comparison(s) will be\n\
against those subexpressions only.  If \"KEY\" is not found in\n\
a block, the sort key becomes the empty string.  The \"Trailer\"\n\
pattern can be used to keep a block of text at the end of the file.\n";

#define zDetail NULL

extern  tUsageProc optionUsage;

tSCC    zFullVersion[] = BLOCKSORT_FULL_VERSION;

tOptions blocksortOptions = {
    OPTIONS_STRUCT_VERSION,
    NULL,         NULL,        zPROGNAME,
    zRcName,      zCopyright,  zCopyrightNotice,
    zFullVersion, apzHomeList, zUsageTitle,
    zExplain,     zDetail,     NULL,
    optionUsage,
    ( OPTPROC_NONE
    + OPTPROC_ERRSTOP
    + OPTPROC_NEGATIONS
    + OPTPROC_NO_ARGS ),
    0, NULL,
    { INDEX_OPT_MORE_HELP,
       0 /* no option state saving */,
      NO_EQUIVALENT /* no '-#' option */,
      3 /* index of default opt */ },
    OPTION_CT, 10 /* user option count */,
    optDesc,
    0, (char**)NULL,  /* original argc + argv    */
    zBugsAddr         /* address to send bugs to */
};

/*
 *  Create the static procedure(s) declared above.
 */
static void
#ifdef __cplusplus
doUsageOpt(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
#else
doUsageOpt( pOpts, pOD )
    tOptions*  pOpts;
    tOptDesc*  pOD;
#endif
{
    USAGE( EXIT_SUCCESS );
}

/* * * * * * *
 *
 *   For the "Pattern Option".
 */
static void
#ifdef __cplusplus
doOptPattern(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
#else
doOptPattern( pOptions, pOptDesc )
    tOptions*   pOptions;
    tOptDesc*   pOptDesc;
#endif
{
    char* pzD;
    char* pzS;

    if (! ENABLED_OPT( COOK ))
        return;

    pzD = pzS = pOptDesc->pzLastArg;

    for (;; ++pzD) {
        char ch = *(pzS++);
        switch (ch) {
        case '\0':
            *pzD = ch;
            return;

        case '\\':
            /*
             *  These are the characters with special meaning
             *  when backslash quoted
             */
            switch (*pzS) {
            case '\\':            pzS++; continue;
            case 'n':  ch = '\n'; pzS++; continue;
            case 't':  ch = '\t'; pzS++; continue;
            case 'f':  ch = '\f'; pzS++; continue;
            case 'r':  ch = '\r'; pzS++; continue;
            }

        default:
            /*
             *  all chars except backslash and those backslashes
             *  not followed by the above noted characters are copied.
             */
            *pzD = ch;
            break;
        }
    }
}

/* * * * * * *
 *
 *   For the "Input Option".
 */
static void
#ifdef __cplusplus
doOptInput(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
#else
doOptInput( pOptions, pOptDesc )
    tOptions*   pOptions;
    tOptDesc*   pOptDesc;
#endif
{
    if (freopen( pOptDesc->pzLastArg, "r", stdin ) != stdin) {
        fprintf( stderr, "Error %d (%s) reopening `%s' as stdin\n",
                 errno, strerror( errno ), pOptDesc->pzLastArg );
        exit( EXIT_FAILURE );
    }
}

/* * * * * * *
 *
 *   For the "Output Option".
 */
static void
#ifdef __cplusplus
doOptOutput(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
#else
doOptOutput( pOptions, pOptDesc )
    tOptions*   pOptions;
    tOptDesc*   pOptDesc;
#endif
{
    if (freopen( pOptDesc->pzLastArg, "w", stdout ) != stdout) {
        fprintf( stderr, "Error %d (%s) reopening `%s' as stdout\n",
                 errno, strerror( errno ), pOptDesc->pzLastArg );
        exit( EXIT_FAILURE );
    }
}

