/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (bsort-opt.h)
 *  
 *  It has been AutoGen-ed  Friday August 23, 2002 at 08:53:21 PM PDT
 *  From the definitions    ./bsort-opt.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the blocksort program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_BSORT_OPT_H_GUARD
#define AUTOOPTS_BSORT_OPT_H_GUARD

/*
 * blocksort copyright 1998-2002 Bruce Korb - all rights reserved
 *
 * blocksort is free software copyrighted by Bruce Korb.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name ``Bruce Korb'' nor the name of any other
 *    contributor may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 
 * blocksort IS PROVIDED BY Bruce Korb ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bruce Korb OR ANY OTHER CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_SYNTAX           =  0,
        INDEX_OPT_PATTERN          =  1,
        INDEX_OPT_INPUT            =  2,
        INDEX_OPT_OUTPUT           =  3,
        INDEX_OPT_KEY              =  4,
        INDEX_OPT_TRAILER          =  5,
        INDEX_OPT_START            =  6,
        INDEX_OPT_SPACING          =  7,
        INDEX_OPT_VERBOSE          =  8,
        INDEX_OPT_VERSION          = 9,
        INDEX_OPT_HELP             = 10,
        INDEX_OPT_MORE_HELP        = 11
} teOptIndex;

#define OPTION_CT    12
#define BLOCKSORT_VERSION       "1.0"
#define BLOCKSORT_FULL_VERSION  "blocksort - Sort Blocks of Text - Ver. 1.0"

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( SYNTAX )
 */
#ifdef __STDC__
#  define       DESC(n) blocksortOptions.pOptDesc[INDEX_OPT_ ## n]
#else
#  define       DESC(n) blocksortOptions.pOptDesc[INDEX_OPT_/**/n]
#endif
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_SYNTAX         0
#define VALUE_OPT_PATTERN        1
#define VALUE_OPT_INPUT          2
#define VALUE_OPT_OUTPUT         3
#define VALUE_OPT_KEY            4
#define VALUE_OPT_TRAILER        5
#define VALUE_OPT_START          6
#define VALUE_OPT_SPACING        7
#define OPT_VALUE_SPACING        (*(long*)(&OPT_ARG(SPACING)))
#define VALUE_OPT_VERBOSE        8

#define VALUE_OPT_VERSION        INDEX_OPT_VERSION
#define VALUE_OPT_HELP           INDEX_OPT_HELP
#define VALUE_OPT_MORE_HELP      INDEX_OPT_MORE_HELP

/*
 *  Interface defines not associated with particular options
 */
#define  ERRSKIP_OPTERR STMTS( blocksortOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define  ERRSTOP_OPTERR STMTS( blocksortOptions.fOptSet |= OPTPROC_ERRSTOP )
#define  RESTART_OPT(n) STMTS( \
                blocksortOptions.curOptIdx = (n); \
                blocksortOptions.pzCurOpt  = NULL )
#define    START_OPT    RESTART_OPT(1)
#define     USAGE(c)    (*blocksortOptions.pUsageProc)( &blocksortOptions, c )

/* * * * * *
 *
 *  Declare the blocksort option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   blocksortOptions;

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_BSORT_OPT_H_GUARD */
