/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (fork.c)
 *  
 *  It has been AutoGen-ed  Sunday January  4, 2004 at 03:14:22 PM PST
 *  From the definitions    ./xmlopts.def
 *  and the template file   fork.tpl
 *
 *  This module will fire up autogen and have it read definitions
 *  from its standard-in.
 */
#include "xmlopts.h"
#include <fcntl.h>
#include <sys/stat.h>

static void
addArg( char* pzArg, int ix )
{
    char** pArgv = xml2agOptions.origArgVect;
    if (ix >= xml2agOptions.origArgCt) {
        xml2agOptions.origArgCt += 5;
        pArgv = realloc( pArgv, sizeof( void* ) * (xml2agOptions.origArgCt+1) );
        if (pArgv == NULL) {
            fprintf( stderr, "No memory for %d args\n",
                     xml2agOptions.origArgCt );
            exit( EXIT_FAILURE );
        }
        xml2agOptions.origArgVect = pArgv;
    }
    pArgv[ ix ] = pzArg;
}


void
forkAutogen( tCC* pzInput )
{
    tSCC zErr[] = "%s fs ERROR %d (%s) on %s\n";
    int fd[2];

    if (pipe( fd ) != 0) {
        fprintf( stderr, zErr, xml2agOptions.pzProgName,
                 errno, strerror( errno ), "pipe(2)" );
        exit( EXIT_FAILURE );
    }

    fflush( stdout );
    fflush( stdin  );

    switch (fork()) {
    case -1:
        fprintf( stderr, zErr, xml2agOptions.pzProgName,
                 errno, strerror( errno ), "fork(2)" );
        exit( EXIT_FAILURE );

    case 0:
        fclose( stdin );
        if (dup2( fd[0], STDIN_FILENO ) != STDIN_FILENO) {
            fprintf( stderr, zErr, xml2agOptions.pzProgName,
                     errno, strerror( errno ), "dup2(2) w/ STDIN_FILENO" );
            exit( EXIT_FAILURE );
        }
        close( fd[1] );
        break;

    default:
        errno = 0;
        outFp = fdopen( fd[1], "w" );
        if (outFp == NULL) {
            fprintf( stderr, zErr, xml2agOptions.pzProgName,
                     errno, strerror( errno ), "fdopen(2) w/ pipe[1]" );
            exit( EXIT_FAILURE );
        }
        close( fd[0] );
        return;
    }

    if (! HAVE_OPT( BASE_NAME )) {
        if (pzInput == NULL)
            pzInput = "stdin";
        else {
            char* pz = strrchr( pzInput, '.' );
            if (pz != NULL) {
                pzInput = pz = strdup( pzInput );
                pz = strrchr( pz, '.' );
                *pz = '\0';
            }
        }
        SET_OPT_BASE_NAME( pzInput );
    }

    {
        tSCC zAg[] = "autogen";
        char*  pzArg;
        int    ix    = 1;

        {
            char* pz = malloc( strlen( xml2agOptions.pzProgPath ) + 7 );
            char* p  = strrchr( xml2agOptions.pzProgPath, '/' );

            if (p == NULL) {
                strcpy( pz, zAg );
            } else {
                size_t len = (p - xml2agOptions.pzProgPath) + 1;
                memcpy( pz, xml2agOptions.pzProgPath, len );
                strcpy( pz + len, zAg );
            }

            addArg( pz, 0 );
        }

        if (HAVE_OPT( TEMPL_DIRS )) {
            int    optCt = STACKCT_OPT( TEMPL_DIRS );
            tCC**  ppOA  = STACKLST_OPT( TEMPL_DIRS );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 14 + strlen( pA ));
                sprintf( pzArg, "--templ_dirs=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        if (HAVE_OPT( LIB_TEMPLATE )) {
            int    optCt = STACKCT_OPT( LIB_TEMPLATE );
            tCC**  ppOA  = STACKLST_OPT( LIB_TEMPLATE );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 16 + strlen( pA ));
                sprintf( pzArg, "--lib_template=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        if (HAVE_OPT( BASE_NAME )) {
            pzArg = malloc( 13 + strlen( OPT_ARG( BASE_NAME )));
            sprintf( pzArg, "--base_name=%s", OPT_ARG( BASE_NAME ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( DEFINITIONS )) {
            pzArg = malloc( 15 + strlen( OPT_ARG( DEFINITIONS )));
            sprintf( pzArg, "--definitions=%s", OPT_ARG( DEFINITIONS ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( LOAD_SCHEME )) {
            pzArg = malloc( 15 + strlen( OPT_ARG( LOAD_SCHEME )));
            sprintf( pzArg, "--load_scheme=%s", OPT_ARG( LOAD_SCHEME ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( LOAD_FUNCTIONS )) {
            pzArg = malloc( 18 + strlen( OPT_ARG( LOAD_FUNCTIONS )));
            sprintf( pzArg, "--load_functions=%s", OPT_ARG( LOAD_FUNCTIONS ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( SKIP_SUFFIX )) {
            int    optCt = STACKCT_OPT( SKIP_SUFFIX );
            tCC**  ppOA  = STACKLST_OPT( SKIP_SUFFIX );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 15 + strlen( pA ));
                sprintf( pzArg, "--skip_suffix=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        if (HAVE_OPT( SELECT_SUFFIX )) {
            int    optCt = STACKCT_OPT( SELECT_SUFFIX );
            tCC**  ppOA  = STACKLST_OPT( SELECT_SUFFIX );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 17 + strlen( pA ));
                sprintf( pzArg, "--select_suffix=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        if (HAVE_OPT( SOURCE_TIME )) {
            addArg( "--source_time", ix++ );
        }

        if (HAVE_OPT( EQUATE )) {
            pzArg = malloc( 10 + strlen( OPT_ARG( EQUATE )));
            sprintf( pzArg, "--equate=%s", OPT_ARG( EQUATE ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( WRITABLE )) {
            addArg( "--writable", ix++ );
        }

        if (HAVE_OPT( LOOP_LIMIT )) {
            pzArg = malloc( 26 );
            sprintf( pzArg, "--loop_limit=%d", (int)OPT_VALUE_LOOP_LIMIT );
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( TIMEOUT )) {
            pzArg = malloc( 23 );
            sprintf( pzArg, "--timeout=%d", (int)OPT_VALUE_TIMEOUT );
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( TRACE )) {
            tSCC* kwlist[] = {
                "nothing",       "templates",     "block-macros",
                "expressions",   "everything" };
            pzArg = malloc( 9 + strlen( kwlist[ OPT_VALUE_TRACE ] ) );
            sprintf( pzArg, "--trace=%s", kwlist[ OPT_VALUE_TRACE ] );
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( TRACE_OUT )) {
            pzArg = malloc( 13 + strlen( OPT_ARG( TRACE_OUT )));
            sprintf( pzArg, "--trace_out=%s", OPT_ARG( TRACE_OUT ));
            addArg( pzArg, ix++ );
        }

        if (HAVE_OPT( SHOW_DEFS )) {
            addArg( "--show_defs", ix++ );
        }

        if (HAVE_OPT( SHOW_SHELL )) {
            addArg( "--show_shell", ix++ );
        }

        if (HAVE_OPT( DEFINE )) {
            int    optCt = STACKCT_OPT( DEFINE );
            tCC**  ppOA  = STACKLST_OPT( DEFINE );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 10 + strlen( pA ));
                sprintf( pzArg, "--define=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        if (HAVE_OPT( UNDEFINE )) {
            int    optCt = STACKCT_OPT( UNDEFINE );
            tCC**  ppOA  = STACKLST_OPT( UNDEFINE );
            do  {
                tCC* pA = *(ppOA++);
                pzArg = malloc( 12 + strlen( pA ));
                sprintf( pzArg, "--undefine=%s", pA );
                addArg( pzArg, ix++ );
            } while (--optCt > 0);
        }

        xml2agOptions.origArgVect[ ix ] = NULL;
        execvp( xml2agOptions.origArgVect[0], xml2agOptions.origArgVect );

        /*
         *  IF the first try fails, it may be because xml2ag and autogen have
         *  different paths.  Try again with just plain "autogen" and let
         *  the OS search "PATH" for the program.
         */
        execvp( zAg, xml2agOptions.origArgVect );
        fprintf( stderr, zErr, xml2agOptions.pzProgName,
                 errno, strerror( errno ), "execvp(2)" );
        exit( EXIT_FAILURE );
    }
}

/*
 * Local Variables:
 * c-file-style: "stroustrup"
 * indent-tabs-mode: nil
 * tab-width: 4
 * End:
 * end of autogen.c */
