dnl  -*- buffer-read-only: t -*- vi: set ro:
dnl 
dnl DO NOT EDIT THIS FILE   (ag_run_posix_regcomp.m4)
dnl 
dnl It has been AutoGen-ed  Monday February  4, 2002 at 08:34:30 PM PST
dnl From the definitions    misc.def
dnl and the template file   conftest.tpl
dnl
dnl @synopsis  AG_RUN_POSIX_REGCOMP
dnl
dnl @success-result
dnl
dnl   * HAVE_POSIX_REGCOMP is #defined as 1
dnl
dnl @failure-result:  there is no output
dnl
dnl @description
dnl   Check that the POSIX compliant regular expression compiler
dnl   is available in the POSIX specified manner, and it works.
dnl   If it fails, we have a backup -- use gnu-regex.
dnl
dnl @version "04-February-2002 at 20:34"
dnl
dnl @author Bruce Korb <bkorb@gnu.org>
dnl
AC_DEFUN([AG_RUN_POSIX_REGCOMP],[
  AC_MSG_CHECKING([whether POSIX compliant regcomp()/regexec()])
  AC_CACHE_VAL([ag_cv_run_posix_regcomp],[
  AC_TRY_RUN([@%:@include <sys/types.h>
@%:@include <regex.h>
int main() {
  int flags = REG_EXTENDED|REG_ICASE|REG_NEWLINE;
  regex_t  re;
  if (regcomp( &re, "^.*@S|@", flags ) != 0)
    return 1;
  return regcomp( &re, "|no.*", flags ); }],
    [ag_cv_run_posix_regcomp=yes],[ag_cv_run_posix_regcomp=no],[ag_cv_run_posix_regcomp=no]
  ) # end of TRY_RUN]) # end of CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_posix_regcomp}])

  if test "X${ag_cv_run_posix_regcomp}" != Xno
  then
    AC_DEFINE([HAVE_POSIX_REGCOMP],[1],
        [Define this if POSIX compliant regcomp()/regexec()])
  fi
]) # end of AC_DEFUN of AG_RUN_POSIX_REGCOMP
