/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (opts.h)
 *  
 *  It has been AutoGen-ed  Monday February  4, 2002 at 08:35:25 PM PST
 *  From the definitions    opts.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the autogen program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_OPTS_H_GUARD
#define AUTOOPTS_OPTS_H_GUARD

/*
 * autogen copyright 1992-2001 Bruce Korb - all rights reserved
 *
 * autogen is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * autogen is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with autogen.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */
#include "config.h"
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_TEMPL_DIRS       =  0,
        INDEX_OPT_OVERRIDE_TPL     =  1,
        INDEX_OPT_LIB_TEMPLATE     =  2,
        INDEX_OPT_BASE_NAME        =  3,
        INDEX_OPT_DEFINITIONS      =  4,
        INDEX_OPT_LOAD_SCHEME      =  5,
        INDEX_OPT_LOAD_FUNCTIONS   =  6,
        INDEX_OPT_SKIP_SUFFIX      =  7,
        INDEX_OPT_SELECT_SUFFIX    =  8,
        INDEX_OPT_SOURCE_TIME      =  9,
        INDEX_OPT_EQUATE           = 10,
        INDEX_OPT_WRITABLE         = 11,
        INDEX_OPT_LOOP_LIMIT       = 13,
        INDEX_OPT_TIMEOUT          = 14,
        INDEX_OPT_TRACE            = 15,
        INDEX_OPT_TRACE_OUT        = 16,
        INDEX_OPT_SHOW_DEFS        = 17,
        INDEX_OPT_SHOW_SHELL       = 18,
        INDEX_OPT_DEFINE           = 20,
        INDEX_OPT_UNDEFINE         = 21,
        INDEX_OPT_VERSION          = 22,
        INDEX_OPT_HELP             = 23,
        INDEX_OPT_MORE_HELP        = 24,
        INDEX_OPT_SAVE_OPTS        = 25,
        INDEX_OPT_LOAD_OPTS        = 26
} teOptIndex;

#define OPTION_CT    27
#define AUTOGEN_VERSION       "5.3.1"
#define AUTOGEN_FULL_VERSION  "autogen - The Automated Program Generator - Ver. 5.3.1"

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( TEMPL_DIRS )
 */
#ifdef __STDC__
#define     DESC(n)     autogenOptions.pOptDesc[INDEX_OPT_ ## n]
#else
#define     DESC(n)     autogenOptions.pOptDesc[INDEX_OPT_/**/n]
#endif
#define     HAVE_OPT(n) (! UNUSED_OPT(&DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_TEMPL_DIRS     'L'
#define SET_OPT_TEMPL_DIRS(a)   STMTS( \
        DESC(TEMPL_DIRS).optActualIndex = 0; \
        DESC(TEMPL_DIRS).optActualValue = VALUE_OPT_TEMPL_DIRS; \
        DESC(TEMPL_DIRS).fOptState &= OPTST_PERSISTENT; \
        DESC(TEMPL_DIRS).fOptState |= OPTST_SET; \
        DESC(TEMPL_DIRS).pzLastArg  = (char*)(a); \
        (*(DESC(TEMPL_DIRS).pOptProc))( &autogenOptions, \
                autogenOptions.pOptDesc + 0 ) )
#define VALUE_OPT_OVERRIDE_TPL   'T'
#define VALUE_OPT_LIB_TEMPLATE   'l'
#define VALUE_OPT_BASE_NAME      'b'
#define VALUE_OPT_DEFINITIONS    4
#define VALUE_OPT_LOAD_SCHEME    'S'
#define SET_OPT_LOAD_SCHEME(a)   STMTS( \
        DESC(LOAD_SCHEME).optActualIndex = 5; \
        DESC(LOAD_SCHEME).optActualValue = VALUE_OPT_LOAD_SCHEME; \
        DESC(LOAD_SCHEME).fOptState &= OPTST_PERSISTENT; \
        DESC(LOAD_SCHEME).fOptState |= OPTST_SET; \
        DESC(LOAD_SCHEME).pzLastArg  = (char*)(a); \
        (*(DESC(LOAD_SCHEME).pOptProc))( &autogenOptions, \
                autogenOptions.pOptDesc + 5 ) )
#define VALUE_OPT_LOAD_FUNCTIONS 'F'
#define VALUE_OPT_SKIP_SUFFIX    's'
#define VALUE_OPT_SELECT_SUFFIX  'o'
#define VALUE_OPT_SOURCE_TIME    9
#define VALUE_OPT_EQUATE         10
#define VALUE_OPT_WRITABLE       11
#define SET_OPT_WRITABLE   STMTS( \
        DESC(WRITABLE).optActualIndex = 11; \
        DESC(WRITABLE).optActualValue = VALUE_OPT_WRITABLE; \
        DESC(WRITABLE).fOptState &= OPTST_PERSISTENT; \
        DESC(WRITABLE).fOptState |= OPTST_SET )
#define DISABLE_OPT_WRITABLE   STMTS( \
        DESC(WRITABLE).fOptState &= OPTST_PERSISTENT; \
        DESC(WRITABLE).fOptState |= OPTST_SET | OPTST_DISABLED; \
        DESC(WRITABLE).pzLastArg  = NULL )
#define VALUE_OPT_LOOP_LIMIT     13
#define OPT_VALUE_LOOP_LIMIT     (*(long*)(&OPT_ARG(LOOP_LIMIT)))
#ifdef ENABLE_SHELL
#define VALUE_OPT_TIMEOUT        't'
#define OPT_VALUE_TIMEOUT        (*(long*)(&OPT_ARG(TIMEOUT)))
#endif
typedef enum {
    TRACE_NOTHING,        TRACE_TEMPLATES,      TRACE_BLOCK_MACROS,
    TRACE_EXPRESSIONS,    TRACE_EVERYTHING
} te_Trace;
#define VALUE_OPT_TRACE          15
#define OPT_VALUE_TRACE          (*(te_Trace*)(&OPT_ARG(TRACE)))
#define VALUE_OPT_TRACE_OUT      16
#ifdef DEBUG
#define VALUE_OPT_SHOW_DEFS      17
#endif
#ifdef DEBUG
#define VALUE_OPT_SHOW_SHELL     18
#endif
#define VALUE_OPT_DEFINE         'D'
#define WHICH_OPT_DEFINE         (DESC(DEFINE).optActualValue)
#define WHICH_IDX_DEFINE         (DESC(DEFINE).optActualIndex)
#define SET_OPT_DEFINE(a)   STMTS( \
        DESC(DEFINE).optActualIndex = 20; \
        DESC(DEFINE).optActualValue = VALUE_OPT_DEFINE; \
        DESC(DEFINE).fOptState &= OPTST_PERSISTENT; \
        DESC(DEFINE).fOptState |= OPTST_SET; \
        DESC(DEFINE).pzLastArg  = (char*)(a); \
        (*(DESC(DEFINE).pOptProc))( &autogenOptions, \
                autogenOptions.pOptDesc + 20 ) )
#define VALUE_OPT_UNDEFINE       'U'
#define SET_OPT_UNDEFINE(a)   STMTS( \
        DESC(DEFINE).optActualIndex = 21; \
        DESC(DEFINE).optActualValue = VALUE_OPT_UNDEFINE; \
        DESC(DEFINE).fOptState &= OPTST_PERSISTENT; \
        DESC(DEFINE).fOptState |= OPTST_SET | OPTST_EQUIVALENCE; \
        DESC(DEFINE).pzLastArg  = (char*)(a); \
        (*(DESC(UNDEFINE).pOptProc))( &autogenOptions, \
                autogenOptions.pOptDesc + INDEX_OPT_DEFINE ) )

#define VALUE_OPT_VERSION        'v'
#define VALUE_OPT_SAVE_OPTS      '>'
#define VALUE_OPT_LOAD_OPTS      '<'
#define VALUE_OPT_HELP           '?'
#define VALUE_OPT_MORE_HELP      '!'

/*
 *  Interface defines not associated with particular options
 */
#define  ERRSKIP_OPTERR STMTS( autogenOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define  ERRSTOP_OPTERR STMTS( autogenOptions.fOptSet |= OPTPROC_ERRSTOP )
#define  RESTART_OPT(n) STMTS( \
                autogenOptions.curOptIdx = (n); \
                autogenOptions.pzCurOpt  = NULL )
#define    START_OPT    RESTART_OPT(1)
#define     USAGE(c)    (*autogenOptions.pUsageProc)( &autogenOptions, c )

/* * * * * *
 *
 *  Declare the autogen option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   autogenOptions;

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTS_H_GUARD */
