/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 09 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 29 july 2007, Siracusa, Jean Michel Sellier

// Universal Physical Constants in M.K.S.C. system

// Boltzmann constant (Joule/Kelvin)
 const double KB=1.380658e-23;
// Electron charge in absolute value (Coulomb)
 const double Q=1.60217733e-19;
// Reduced Planck constant (Joule*sec)
 const double HBAR=1.05457266e-34;
// Permittivity of free space (F/m)
 const double EPS0=8.854187817e-12;
// Electron Mass (Kg)
 const double M=9.1093897e-31;
// Pi number
 const double PI=3.141592654;
// electron energy step (eV) for the MC method
 const double DE=0.002;
