/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 09 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 09 june 2007, Siracusa, Jean Michel Sellier

// simply read the precedently calculated neighbourhood table

void read_neighbourhood_table(void)
{
 int i,j;
 FILE *fp;
 
// this is for the non-neighboring faces elements
 for(i=0;i<Ne;i++) for(j=0;j<4;j++) vois[j][i]=-1;

// open the input file where the computed neighbourhood table has been saved
 fp=fopen("neighbourhood_table.dat","r");
 if(fp==NULL){
  printf("read_neighbourhood_table error : problem in opening the file!\n");
  system("PAUSE");
  exit(0);
 }
// read the data
 for(i=0;i<Ne;i++) for(j=0;j<4;j++) fscanf(fp,"%d",&vois[j][i]);

// output on the screen
// for(i=0;i<Ne;i++){
//    for(j=0;j<4;j++) printf("%d ",vois[j][i]);
//    printf("\n");
// }
// close the input file
 fclose(fp);
}
