/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 13 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 22 july 2007, Siracusa, Jean Michel Sellier

// updates the electrostatic potential according to the new
// charge distribution.

// At this first development stage, we only take into account electrons
// We use the principle of superposition of electrostatic fields

void update_potential(void) //(double x[],int itol,double tol,int itmax)
{
// remember the Coulomb law :
// V(r) = 1/(epsr*epsilon0) * q/r
 register int i,j;
// double *vertex;
// double *de; 
 double *tc; // total charge per every vertex
 
/*
 for(i=0;i<Ne;i++){
  int k;
  for(j=0;j<4;j++)
   for(k=0;k<1000;k++)
    V[noeud_geo[j][i]-1]+=0.0015e-12*(-Q*(NE[noeud_geo[j][i]-1]-ND[i]));
 }
 return;*/
 
// vertex=malloc((Ng+1)*sizeof(double));
// de=malloc((Ng+1)*sizeof(double));
 tc=malloc((Ng+1)*sizeof(double)); 
 if(/*vertex==NULL || de==NULL ||*/ tc==NULL){
  printf("update_potential : not enough memory for dynamical allocation!\n");
  system("PAUSE");
  exit(0);
 }

// for(i=0;i<Ng;i++) de[i]=vertex[i]=0;
/* 
 for(i=0;i<Ne;i++){
//printf("%g %g\n",NE[noeud_geo[0][i]-1],VOLUME[i]);
      de[noeud_geo[0][i]-1]+=NE[noeud_geo[0][i]-1]*VOLUME[i];
      de[noeud_geo[1][i]-1]+=NE[noeud_geo[1][i]-1]*VOLUME[i];
      de[noeud_geo[2][i]-1]+=NE[noeud_geo[2][i]-1]*VOLUME[i];
      de[noeud_geo[3][i]-1]+=NE[noeud_geo[3][i]-1]*VOLUME[i];

      vertex[noeud_geo[0][i]-1]++;
      vertex[noeud_geo[1][i]-1]++;
      vertex[noeud_geo[2][i]-1]++;
      vertex[noeud_geo[3][i]-1]++;
 }
 for(i=0;i<Ng;i++){
//   printf("de = %g vertex = %d\n",de[i],vertex[i]);
   de[i]/=vertex[i]; // de[i] = number of electrons in the i-th vertex
//   printf("de = %g\n",de[i]);
 }*/

 
// total charge in the i-th element
 for(i=0;i<Ne;i++){
   double de;
   de=0.25*(NE[noeud_geo[0][i]-1]+NE[noeud_geo[1][i]-1]+
            NE[noeud_geo[2][i]-1]+NE[noeud_geo[3][i]-1]);
   tc[noeud_geo[0][i]-1]=-Q*(de-ND[i])*VOLUME[i];
   tc[noeud_geo[1][i]-1]=-Q*(de-ND[i])*VOLUME[i];
   tc[noeud_geo[2][i]-1]=-Q*(de-ND[i])*VOLUME[i];
   tc[noeud_geo[3][i]-1]=-Q*(de-ND[i])*VOLUME[i];
//   printf("de = %g da = %g tc=%g\n",de,ND[i],tc[i]);
 }
//exit(0); 

// update the potential according to the Coulomb force
//printf("here...\n");
 for(i=0;i<Ng;i++) V[i]=0.; // just in case
 for(i=0;i<Ng;i++){
   for(j=0;j<Ng;j++){
//     printf("V = %g %g\n",Vi[j],tc[i]*k[i]/resr[i][j]);
// maintain the charge neutrality and avoid NaN
     if(j!=i && i_front[j]!=OHMIC && i_front[j]!=SCHOTTKY
             && i_front[i]!=OHMIC && i_front[i]!=SCHOTTKY) V[j]+=tc[i]*k[i]/resr[i][j];

//     printf("V = %g\n",V[j]);
   }
 }
// for(i=0;i<Ng;i++) printf("%g\n",V[i]);
 for(i=0;i<Ng;i++) V[i]+=Vi[i];

//   V[i]=Vi[i];
//printf("that's it!\n");
 
/*
 printf("\nSolving the 3D Poisson equation...\n");
  linbcg(Ng,b,x,itol,tol,itmax);
 printf("Poisson equation solved...\n\n");*/
// free(vertex);
// free(de);
 free(tc);
}
