/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 10 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// calculation of some paraters + various scattering rates for
// all the elements implemented in this code

void montecarlo_setup(int material)
{
 double wo,no,dos,aco,oge[7],oga[7];
// double ogeg,ogag;
 double dos1,dos2,am1,am2,cl,deq,dij;
 double hwe,hwij,wij,we,ne,nij;
 double poe,poa,ope,opa,eqe,eqa,qmin,qmax;
 double initialenergy,sei,finalenergy,sef;
 double eps,epf,ep,bimp,cimp,qd;
 double ak,qq,wk;
 int ie,i;
 int z2=4;

// These definitions are valid for every material
 BKTQ=KB*TL/Q; // in eV
 QH=Q/HBAR;

// Material with 2 valleys
// #######################
 if(NOVALLEY[material]==2){
// Effective mass for the GAMMA and L-Valley, respectively
  am1=MSTAR[material][1]*M;
  am2=MSTAR[material][2]*M;
// Energy minima of bands
  EC[material][1]=EMIN[material][1];
  EC[material][2]=EMIN[material][2];
// Energy gap
//  eg=EG[material];
  eps=EPSR[material]*EPS0;
  epf=EPF[material]*EPS0;
  ep=1./(1./epf-1./eps);

// Parameters for Phonon Scattering
  cl=RHO[material]*pow(UL[material],2.);
  deq=dij=DTK[material][0]*Q;
  hwe=hwij=HWO[material][0];
// Non-parabolicity of GAMMA and L bands
  AF[material][1]=alphaK[material][1];
  AF[material][2]=alphaK[material][2];

  SMH[material][1]=sqrt(2.*am1*Q)/HBAR;
  SMH[material][2]=sqrt(2.*am2*Q)/HBAR;
  HHM[material][1]=HBAR*HBAR/(2.*am1*Q);
  HHM[material][2]=HBAR*HBAR/(2.*am2*Q);
  HM[material][1]=HBAR/am1;
  HM[material][2]=HBAR/am2;

  wo=HWO[material][0]*Q/HBAR;
  wij=hwij*Q/HBAR;
  we=hwe*Q/HBAR;

  no=1./(exp(HWO[material][0]/BKTQ)-1.);
  nij=1./(exp(hwij/BKTQ)-1.);
  ne=1./(exp(hwe/BKTQ)-1.);

  dos1=pow(sqrt(2.*am1*Q)/HBAR,3.)/pow(2.*PI,2.);
  dos2=pow(sqrt(2.*am2*Q)/HBAR,3.)/pow(2.*PI,2.);

  poe=Q/8./PI/ep*Q*wo*(no+1.);
  poa=poe*no/(1.+no);
  aco=2.*PI*DA[material]/Q*DA[material]*BKTQ/HBAR*Q/cl;
  ope=PI*dij/wij*dij/RHO[material]/Q*(nij+1.);
  opa=ope*nij/(1.+nij);
  eqe=PI*deq/we*deq/RHO[material]/Q*(ne+1.);
  eqa=eqe*ne/(1.+ne);

// Parameters for impurity scatterings
  cimp=CIMP; // <--- impurity concentration
  qd=sqrt(Q*cimp/BKTQ/eps);
  QD2=qd*qd;
  bimp=2.*PI*cimp*Q*Q/HBAR*Q/eps/eps;

// Calculation of scattering rates
  for(ie=1;ie<=DIME;ie++){
    initialenergy=DE*((double)(ie));
    sei=sqrt(initialenergy);
// GAMMA-valley
// ============
// Polar optical phonon
// Emission - Parabolic
    finalenergy=initialenergy-HWO[material][0];
    if(finalenergy>0.){
     sef=sqrt(finalenergy);
     qmax=sef+sei;
     qmin=sei-sef;
     SWK[material][1][1][ie]=poe*SMH[material][1]*sei/initialenergy/Q*log(qmax/qmin);
    }
    else SWK[material][1][1][ie]=0.;
// Absorption - Parabolic
    finalenergy=initialenergy+HWO[material][0];
    sef=sqrt(finalenergy);
    qmax=sef+sei;
    qmin=sef-sei;
    SWK[material][1][2][ie]=SWK[material][1][1][ie]
                 +poa*SMH[material][1]*sei/initialenergy/Q*log(qmax/qmin);
// Emission
    finalenergy=initialenergy-hwij+EC[material][1]-EC[material][2];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
     SWK[material][1][3][ie]=SWK[material][1][2][ie]+z2*ope*sef*dos2*
                         (1.+2.*AF[material][2]*finalenergy);
    }
    else SWK[material][1][3][ie]=SWK[material][1][2][ie];
// Absorption
    finalenergy=initialenergy+hwij+EC[material][1]-EC[material][2];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
     SWK[material][1][4][ie]=SWK[material][1][3][ie]+z2*opa*sef*dos2*
                         (1.+2.*AF[material][2]*finalenergy);
    }
    else SWK[material][1][4][ie]=SWK[material][1][3][ie];
// Acoustic Phonon
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[material][1]*finalenergy));
    SWK[material][1][5][ie]=SWK[material][1][4][ie]+aco*sef*dos1*
                        (1.+2.*AF[material][1]*finalenergy);
// Impurity scattering
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[material][1]*finalenergy));
    ak=SMH[material][1]*sef;
    qq=QD2*(4.*ak*ak+QD2);
    wk=bimp/qq*sef*dos1*(1.+2.*AF[material][1]*finalenergy);
    if(wk>1.e14) wk=1.e14;
    SWK[material][1][6][ie]=SWK[material][1][5][ie]+wk;

// Impact Ionization
    wk=PII[material]*pow((initialenergy-ETH[material])/ETH[material],2.);
    if(IIFLAG==YES) SWK[material][1][7][ie]=SWK[material][1][6][ie]+wk;
    if(IIFLAG==NO) SWK[material][1][7][ie]=SWK[material][1][6][ie];
    
// L-valley
// ========
// Polar optical phonon
// Emission
    finalenergy=initialenergy-HWO[material][0];
    if(finalenergy>0.){
      sef=sqrt(finalenergy);
      qmax=sef+sei;
      qmin=sei-sef;
      SWK[material][2][1][ie]=poe*SMH[material][2]*sei/initialenergy/Q*log(qmax/qmin);
    }
    else SWK[material][2][1][ie]=0.;
// Absorption
    finalenergy=initialenergy+HWO[material][0];
    sef=sqrt(finalenergy);
    qmax=sef+sei;
    qmin=sef-sei;
    SWK[material][2][2][ie]=SWK[material][2][1][ie]
                 +poa*SMH[material][2]*sei/initialenergy/Q*log(qmax/qmin);
// Non-polar optical phonon
// Emission
    finalenergy=initialenergy-hwe;
    if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
      SWK[material][2][3][ie]=SWK[material][2][2][ie]
                   +(z2-1.)*eqe*sef*dos2*(1.+2.*AF[material][2]*finalenergy);
    }
    else SWK[material][2][3][ie]=SWK[material][2][2][ie];
// Absorption
    finalenergy=initialenergy+hwe;
    sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
    SWK[material][2][4][ie]=SWK[material][2][3][ie]
                 +(z2-1.)*eqa*sef*dos2*(1.+2.*AF[material][2]*finalenergy);

// Emission
    finalenergy=initialenergy-hwij+EC[material][2]-EC[material][1];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[material][1]*finalenergy));
     SWK[material][2][5][ie]=SWK[material][2][4][ie]+ope*sef*dos1*
                         (1.+2.*AF[material][1]*finalenergy);
    }
    else SWK[material][2][5][ie]=SWK[material][2][4][ie];
// Absorption
    finalenergy=initialenergy+hwij+EC[material][2]-EC[material][1];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[material][1]*finalenergy));
     SWK[material][2][6][ie]=SWK[material][2][5][ie]+opa*sef*dos1*
                         (1.+2.*AF[material][1]*finalenergy);
    }
    else SWK[material][2][6][ie]=SWK[material][2][5][ie];
// Acoustic phonon
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
    SWK[material][2][7][ie]=SWK[material][2][6][ie]+aco*sef*dos2*
                        (1.+2.*AF[material][2]*finalenergy);
// Impurity scattering
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[material][2]*finalenergy));
    ak=SMH[material][2]*sef;
    qq=QD2*(4.*ak*ak+QD2);
    wk=bimp/qq*sef*dos2*(1.+2.*AF[material][2]*finalenergy);
    if(wk>1.e14) wk=1.e14;
    SWK[material][2][8][ie]=SWK[material][2][7][ie]+wk;
  } // <--- this is the correct place for the symbol } (J.M.Sellier,24/12/2006)

// Impact Ionization
    wk=PII[material]*pow((initialenergy-ETH[material])/ETH[material],2.);
    if(IIFLAG==YES) SWK[material][2][9][ie]=SWK[material][2][8][ie]+wk;
    if(IIFLAG==NO) SWK[material][2][9][ie]=SWK[material][2][8][ie];

// Evalutation of gamma
  GM[material]=SWK[material][1][7][1];
  for(ie=1;ie<=DIME;ie++){
    if(SWK[material][1][7][ie]>GM[material]) GM[material]=SWK[material][1][7][ie];
    if(SWK[material][2][9][ie]>GM[material]) GM[material]=SWK[material][2][9][ie];
  }
  printf("GAMMA[%d]   = %g \n",material, GM[material]);
  for(i=1;i<=7;i++)
    for(ie=1;ie<=DIME;ie++)
      SWK[material][1][i][ie]/=GM[material];
  for(i=1;i<=9;i++)
    for(ie=1;ie<=DIME;ie++)
      SWK[material][2][i][ie]/=GM[material];
 }
// End of 2-valley materials
// #########################

// Material with one valley
// ########################
 if(NOVALLEY[material]==1){
  SMH[material][1]=sqrt(2.*MSTAR[material][1]*M*Q)/HBAR;
  HHM[material][1]=HBAR*HBAR/(2.*MSTAR[material][1]*M*Q);
  HM[material][1]=HBAR/(MSTAR[material][1]*M);
// Density of states
  dos=pow((sqrt(2.*MSTAR[material][1]*M)*sqrt(Q)/HBAR),3.)/(4.*PI*PI);
// constant for the acoustic phonon
  aco=2.*PI*(DA[material]/Q)
     *DA[material]*(BKTQ/HBAR)*(Q/(RHO[material]*UL[material]*UL[material]));
// Constants for the 6 (or less) non-polar optical phonons
  for(i=1;i<=6;i++){
// i-th Optical Phonon
    oge[i]=0.;
    oga[i]=0.;
    if(ZF[material][i-1]!=0.){
      wo=HWO[material][i-1]*Q/HBAR; // frequency of phonon
      no=1./(exp(HWO[material][i-1]/BKTQ) - 1.); // population of phonons
      oge[i]=ZF[material][i-1]*PI*(DTK[material][i-1]*Q/wo)
            *((DTK[material][i-1]*Q/RHO[material])/Q)*(no+1.);
      oga[i]=oge[i]*no/(1.+no);
   }
  }
// Calculation of scattering rates
 for(ie=1; ie<=DIME; ++ie) SWK[material][0][0][ie]=0.;
 for(ie=1; ie<=DIME; ++ie){
   initialenergy=DE*((double) ie);
   sei=sqrt(initialenergy);
// non polar optical phonons
   for(i=1;i<=6;i++){
     finalenergy=initialenergy-HWO[material][i-1];
     SWK[material][0][i*2-1][ie]=SWK[material][0][i*2-2][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaK[material][1]*finalenergy));
      SWK[material][0][i*2-1][ie]=SWK[material][0][i*2-2][ie]
                    +oge[i]*sef*dos*(1.+2.*alphaK[material][1]*finalenergy);
     }
     finalenergy=initialenergy+HWO[material][i-1];
     SWK[material][0][i*2][ie]=SWK[material][0][i*2-1][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaK[material][1]*finalenergy));
      SWK[material][0][i*2][ie]=SWK[material][0][i*2-1][ie]
                  +oga[i]*sef*dos*(1.+2.*alphaK[material][1]*finalenergy);
     }
   }
// Acoustic phonon
   finalenergy=initialenergy;
   sef=sqrt(finalenergy*(1.+alphaK[material][1]*finalenergy));
   SWK[material][0][13][ie]=SWK[material][0][12][ie]
                 +aco*sef*dos*(1.+2.*alphaK[material][1]*finalenergy);

// Impact Ionization
    wk=PII[material]*pow((initialenergy-ETH[material])/ETH[material],2.);
    if(IIFLAG==YES) SWK[material][0][14][ie]=SWK[material][0][13][ie]+wk;
    if(IIFLAG==NO) SWK[material][0][14][ie]=SWK[material][0][13][ie];
  }

// Evaluation of gamma
  GM[material]=SWK[material][0][14][1];
  for(ie=1;ie<=DIME;++ie)
    if(SWK[material][0][14][ie]>GM[material]) GM[material]=SWK[material][0][14][ie];
  printf("GAMMA[%d]   = %g \n", material, GM[material]);
  for(ie=1;ie<=DIME;ie++)
    for(i=1;i<=14;i++)
      SWK[material][0][i][ie]/=GM[material];
 }
// End of one-valley materials
}
