/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 06 june 2007, Siracusa, Jean Michel Sellier

// see french book pag.319 tab.9.3
// Gauss Formula in 4 points and 3 dimensions
// ********
// xi[0][i] reppresents the local coordinate \xi
// xi[1][i] reppresents the local coordinate \eta
// xi[2][i] reppresents the local coordinate \xeta
// ********

void initialize_GAUSS(void)
{
double a=(5.-sqrt(5))/20.;

// the local coordinate \xi
 xi[0][0] =1.-3.*a;
 xi[0][1] =a;
 xi[0][2] =a;
 xi[0][3] =a;

// the local coordinate \eta
 xi[1][0] =a;
 xi[1][1] =1.-3.*a;
 xi[1][2] =a;
 xi[1][3] =a;

// the local coordinate \xeta
 xi[2][0] =a;
 xi[2][1] =a;
 xi[2][2] =1.-3.*a;
 xi[2][3] =a;

// the gaussian weights
 omega[0] =0.25;
 omega[1] =0.25;
 omega[2] =0.25;
 omega[4] =0.25;

 printf("Gauss integration formula points and weights initialised...\n");
}

