/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 06 june 2007, Siracusa, Jean Michel Sellier

// Defines the value of the local shape functions (\psi_n and \theta_n which are 
// coincident in our case) in the various local Gauss standard local points. 
// (isoparametric transformations).

void def_base_all(void)
{
 int n,l;

// printf("\n");

 for(n=0;n<ng;n++)
  for(l=0;l<lg;l++){
   base_geo[n][l]=theta(n,xi[0][l],xi[1][l],xi[2][l]);
//   printf("base_geo[%d][%d] = %g\n",n,l,base_geo[n][l]);
  }

// printf("\n");

 for(n=0;n<ng;n++)
  for(l=0;l<lg;l++){
   base_ref[n][l]=theta(n,xi[0][l],xi[1][l],xi[2][l]);
//   printf("base_ref[%d][%d] = %g\n",n,l,base_ref[n][l]);
  }

 printf("base_geo[][] and base_ref[][] are now defined...\n");
}

