Index: strftime.txh
===================================================================
RCS file: /cvs/djgpp/djgpp/src/libc/ansi/time/strftime.txh,v
retrieving revision 1.6
diff -u -t -F^@[[:alpha:]] -r1.6 strftime.txh
--- strftime.txh	8 Nov 2003 12:19:40 -0000	1.6
+++ strftime.txh	17 Mar 2004 06:39:48 -0000
@@ -5,145 +5,187 @@
 @example
 #include <time.h>
 
-size_t strftime(char *buf, size_t n, const char *format,
-                const struct tm *time_info);
+size_t strftime(char * restrict string,
+                size_t maxsize,
+                const char * restrict format,
+                const struct tm * restrict time_info);
+
 @end example
 
 @subheading Description
 
-This function formats the time data in @var{time_info} according to the
-given @var{format} and stores it in @var{buf}, not exceeding @var{n}
-bytes.
-
-The format string is like @code{printf} in that any character other than
-@code{%} is added to the output string, and for each character following
-a @code{%} a pattern is added to the string as follows, with the
-examples as if the time was Friday, October 1, 1993, at 03:30:34 PM EDT:
+This function formats the calendar time data in @var{time_info}
+according to the given format string @var{format}
+and stores it in the output string @var{string},
+not exceeding @var{maxsize} bytes.
+
+The format string is like @code{sprintf} in that any character other
+than the flag character @code{%} is added to the output string, and
+depending on the conversion specifier character after the @code{%},
+characters are added to the output string, with the following examples
+shown as if the time was Friday, October 1, 1993, at 03:30:34 PM EDT:
 
 @table @code
 
 @item %A
 
-The full weekday name (@code{Friday})
+The full weekday name represented according to the
+current locale: (@code{Friday}) in the C locale
 
 @item %a
 
-The abbreviated weekday name (@code{Fri})
+The abbreviated weekday name represented according to
+the current locale: (@code{Fri}) in the C locale
 
 @item %B
 
-The full month name (@code{October})
+The full month name represented according to the 
+current locale: (@code{October}) in the C locale
 
 @item %b
 @itemx %h
 
-The abbreviated month name (@code{Oct})
+The abbreviated month name represented according to 
+the current locale: (@code{Oct}) in the C locale
 
 @item %C
 
-Short for @code{%a %b %e %H:%M:%S %Y} (@code{Fri Oct  1 15:30:34 1993})
+The century of the year, zero padded to two digits (@code{19})
 
 @item %c
 
-Short for @code{%m/%d/%y %H:%M:%S} (@code{10/01/93 15:30:34})
+The date and time represented according to the current locale: short for
+@code{%a %b %e %T %Y} (@code{Fri Oct  1 15:30:34 1993}) in the C locale
+
+@item %D
+
+The date in POSIX format; short for @code{%m/%d/%y} (@code{10/01/93})
+
+@item %d
+
+The day of the month (01-31), zero padded to two digits (@code{01})
 
 @item %e
 
-The day of the month, blank padded to two characters (@code{ 2})
+The day of the month (1-31), blank padded to two characters (@code{ 1})
 
-@item %D
+@item %F
 
-Short for @code{%m/%d/%y} (@code{10/01/93})
+The date in ISO format; short for @code{%Y-%m-%d} (@code{1993-10-01})
 
-@item %d
+@item %G
 
-The day of the month, zero padded to two characters (@code{02})
+The ISO week based year, zero padded to four digits (@code{1993})
+
+@item %g
+
+The ISO week based year of the century (00-99),
+zero padded to two digits (@code{93})
 
 @item %H
 
-The hour (0-24), zero padded to two characters (@code{15})
+The hour in the 24 hour clock (00-24), zero padded to two digits (@code{15})
 
 @item %I
 
-The hour (1-12), zero padded to two characters (@code{03})
+The hour in the 12 hour clock (01-12), zero padded to two digits (@code{03})
 
 @item %j
 
-The Julian day, zero padded to three characters (@code{275})
+The Julian day of the year (001-366), zero padded to three digits (@code{274})
 
 @item %k
 
-The hour (0-24), space padded to two characters (@code{15})
+The hour in the 24 hour clock (0-24),
+space padded to two characters (@code{15})
 
 @item %l
 
-The hour (1-12), space padded to two characters(@code{ 3})
+The hour in the 12 hour clock (1-12),
+space padded to two characters (@code{ 3})
 
 @item %M
 
-The minutes, zero padded to two characters (@code{30})
+The minutes in the hour (00-59), zero padded to two digits (@code{30})
 
 @item %m
 
-The month (1-12), zero padded to two characters (@code{10})
+The month in the year (01-12), zero padded to two digits (@code{10})
 
 @item %n
 
-A newline (@code{\n})
+The newline control character (@code{\n})
 
 @item %p
 
-AM or PM (@code{PM})
+The AM/PM indicator in the 12 hour clock represented according
+to the current locale: (@code{PM}) in the C locale
 
 @item %R
 
-Short for @code{%H:%M} (@code{15:30})
+The time in the 24 hour clock, excluding seconds;
+short for @code{%H:%M} (@code{15:30})
 
 @item %r
 
-Short for @code{%I:%M:%S %p} (@code{03:30:35 PM})
+The time in the 12 hour clock represented according to the current locale:
+short for @code{%I:%M:%S %p} (@code{03:30:35 PM}) in the C locale
 
 @item %S
 
-The seconds, zero padded to two characters (@code{35})
+The seconds in the minute (00-60), zero padded to two digits (@code{35});
+the maximum value is 60 to allow leap seconds to be represented
+
+@item %s
+
+The number of seconds since 1970-01-01 00:00:00 UTC (@code{749503834})
 
 @item %T
 
-Short for @code{%H:%M:%S} (@code{15:30:35})
+The time in the 24 hour clock, including seconds;
+short for @code{%H:%M:%S} (@code{15:30:35})
 
 @item %t
 
-A tab (@code{\t})
+The horizontal tab control character (@code{\t})
 
 @item %U
 
-The week of the year, with the first week defined by the first Sunday of
-the year, zero padded to two characters (@code{39})
+The Sunday based week of the year (00-53), with the first week defined
+by the first Sunday of the year, zero padded to two digits (@code{39})
 
 @item %u
 
-The day of the week (1-7) (@code{6})
+The ISO Monday based day of the week (Mon 1-Sun 7) (@code{5})
+
+@item %V
+
+The ISO Monday based week of the year (01-53), with the first and last
+weeks defined by the first and last Thursdays of the year, zero padded
+to two digits (@code{39})
 
 @item %W
 
-The week of the year, with the first week defined by the first Monday of
-the year, zero padded to two characters (@code{39})
+The Monday based week of the year (00-53), with the first week defined
+by the first Monday of the year, zero padded to two digits (@code{39})
 
 @item %w
 
-The day of the week (0-6) (@code{5})
+The Sunday based day of the week (Sun 0-Sat 6) (@code{5})
 
 @item %x
 
-Date represented according to the current locale.
+The date represented according to the current locale:
+short for @code{%D} (@code{10/01/93}) in the C locale
 
 @item %X
 
-Time represented according to the current locale.
+The time in the 24 hour clock represented according to the current
+locale: short for @code{%T} (@code{15:30:34}) in the C locale
 
 @item %y
 
-The year (00-99) of the century (@code{93})
+The year of the century (00-99), zero padded to two digits (@code{93})
 
 @item %Y
 
@@ -151,11 +193,54 @@
 
 @item %Z
 
-The timezone abbreviation (@code{EDT})
+The timezone abbreviation represented according
+to the current locale (@code{EDT})
+
+@item %z
+
+The ISO timezone offset in [+-]HHMM format (@code{-0400})
 
 @item %%
 
-A percent symbol (@code{%})
+The percent symbol character (@code{%})
+
+@end table
+
+@subheading Conversion Modifiers
+
+The following conversion modifier characters affect the conversion into
+the output string and must appear after the flag character (@code{%})
+and before the conversion specifier character.
+
+@table @code
+
+@item -
+
+Left justify the output with no padding characters,
+for example @code{%-d} gives @code{1}
+
+@item 0
+
+Right justify the output with zero digit padding,
+for example @code{%0d} gives @code{01}
+
+@item _
+
+Right justify the output with space character padding,
+for example @code{%_d} gives @code{ 1}
+
+@item ^
+
+Convert lowercase letters in the output to uppercase,
+for example @code{%^a} gives @code{FRI}
+
+@item E
+
+Locale alternate era output format; ignored in the C locale
+
+@item O
+
+Locale alternate digits output format; ignored in the C locale
 
 @end table
 
@@ -165,7 +250,7 @@
 
 @subheading Portability
 
-@portability ansi, posix
+@portability ANSI, POSIX
 
 @subheading Example
 
