/* whitebxl.c
   White box tests
   attempt to exercise all paths through each tested function routine.
   Float complex version.

   S. L. Moshier
   May, 2004  */

#include <stdio.h>
#include <math.h>
#include <float.h>
#include "complex.h"

#define TEST_DENORMAL 1

struct oneargument
  {
    char *name;			/* Name of the function. */
    long double complex (*func) (long double complex);
    long double real_arg;	/* Function argument, assumed exact.  */
    long double imag_arg;
    long double real_ans;
    long double imag_ans;
    int thresh;			/* Error report threshold. 2 = 1 ULP approx. */
  };


struct oneargument test1[] =
{
  { "casinl", casinl, 0.0L, 0.0L, 0.0L, 0.0L, 0},
  { "casinl", casinl, 1.0L, 0.0L, M_PI_2l, 0.0L, 0},
  { "casinl", casinl, 2.0L, 0.0L, M_PI_2l, 0.0L, 0},
  { "casinl", casinl, 1.0L, -1.0L,
	+6.66239432492515255104004895977792720667490E-1L,
	-1.06127506190503565203301891621357348580679E0L, 0},
  { "casinl", casinl, 1.0L, +1.0L,
	+6.66239432492515255104004895977792720667490E-1L,
	+1.06127506190503565203301891621357348580679E0L, 0},
  { "csinl", csinl, 0.0L, 0.0L, 0.0L, 0.0L, 0},
  { "csinl", csinl, M_PI_2l, 0.0L, 1.0L, 0.0L, 0},
  { "csinl", csinl, +6.66239432492515255104004895977792720667490E-1L,
		    -1.06127506190503565203301891621357348580679E0L,
			 1.0L, -1.0L, 0},
  { "csinl", csinl, +6.66239432492515255104004895977792720667490E-1L,
		    +1.06127506190503565203301891621357348580679E0L,
			 1.0L, +1.0L, 0},
  { "catanl", catanl, 0.0L, 0.0L, 0.0L, 0.0L, 0},
  { "catanl", catanl, 0.0L, +1.0L, LDBL_MAX, LDBL_MAX, 0},
  { "catanl", catanl, 0.0L, -1.0L, LDBL_MAX, LDBL_MAX, 0},
  { "catanl", catanl, 1.0L, +1.0L,
	+1.01722196789785136772278896155048292206356E0L,
	+4.02359478108525093650189833306546909881400E-1L, 0},
  { "catanl", catanl, 1.0L, -1.0L,
	+1.01722196789785136772278896155048292206356E0L,
	-4.02359478108525093650189833306546909881400E-1L, 0},
  { "catanl", catanl, 1.0253320612293392426711606796797685569408978E0L,
		      3.7861089368147738696922570187830763998261106E0L,
		      1.5L, 0.25L, 0},
  { "catanl", catanl, -2.0L, 1.0L,
	-1.17809724509617246442349126872981358157394E0L,
	+1.73286795139986327354308030364544142018875E-1L,
	 0},
  {"csqrtl", csqrtl, 0.0L, 0.0L, 0.0L, 0.0L, 0},
  {"csqrtl", csqrtl, 1.0L, 0.0L, 1.0L, 0.0L, 0},
  {"csqrtl", csqrtl, -1.0L, 0.0L, 0.0L, 1.0L, 0},
  {"csqrtl", csqrtl, 0.0L, 1.0L,
   0.7071067811865475244008443621048490392848L,
   0.7071067811865475244008443621048490392848L, 0},
  {"csqrtl", csqrtl, 0.0L, -1.0L,
    0.7071067811865475244008443621048490392848L,
   -0.7071067811865475244008443621048490392848L, 0},
  {"csqrtl", csqrtl, 1.0L, 1.0L,
   1.098684113467809966039801195240678378544L,
   0.455089860562227341304357757822468569620L, 0},
  {"csqrtl", csqrtl, 1.0L, -1.0L,
   1.098684113467809966039801195240678378544L,
   -0.455089860562227341304357757822468569620L, 0},
  {"csqrtl", csqrtl, -1.0L, 1.0L,
   0.455089860562227341304357757822468569620L,
   1.098684113467809966039801195240678378544L, 0},
  {"csqrtl", csqrtl, -1.0L, -1.0L,
   0.455089860562227341304357757822468569620L,
   -1.098684113467809966039801195240678378544L, 0},
  {"csqrtl", csqrtl,
   1.189731495357231765021263853030970205169e4932L,	// 2^16384*(1-2^(-64))
   1.189731495357231765021263853030970205169e4932L,
   1.198387648399684544289722483367574194426e2466L,
   4.963884169475494329296140030180041297763e2465L, 0},
#if TEST_DENORMAL
  {"csqrtl", csqrtl,
   3.64519953188247460252840593361941981639905e-4951L,
   3.64519953188247460252840593361941981639905e-4951L,
   6.63335893323538141885633017618228043012283e-2476L,
   2.74762723423482089684766697470153729452931e-2476L, 0},
#endif
  { "ctanl", ctanl, 0.0L, 0.0L, 0.0L, 0.0L, 0},
  { "ctanl", ctanl, M_PI_2l, 0.0L, LDBL_MAX, LDBL_MAX, 0},
  { "ctanl", ctanl, 1.5L, 0.25L,
    	+1.0253320612293392426711606796797685569408978E0L,
   	+3.7861089368147738696922570187830763998261106E0L, 0},
  { "ctanl", ctanl, -1.5L, +0.25L,
	-1.0253320612293392426711606796797685569409E0L,
	+3.7861089368147738696922570187830763998261E0L,
	 0},
  { "ctanl", ctanl,
	+1.01722196789785136772278896155048292206356E0L,
	+4.02359478108525093650189833306546909881400E-1L,
	1.0L, +1.0L, 0},
  { "ctanl", ctanl,
	+1.01722196789785136772278896155048292206356E0L,
	-4.02359478108525093650189833306546909881400E-1L,
	1.0L, -1.0L, 0},
  { "ctgammal", ctgammal, 0.0L, 0.0L, LDBL_MAX, LDBL_MAX,
		0},
  { "ctgammal", ctgammal, -21.0L, 0.0L, LDBL_MAX, LDBL_MAX,
		0},
  { "ctgammal", ctgammal, 1.e-12L, 1.e-12L,
	 4.9999999999942278433509945619538881588247E11L,
	-4.9999999999999999999999901094400467384240E11L,
		0},
  { "ctgammal", ctgammal, +18.385L, +18.385L, 
	+1.5545154323826133460748425489524312902105E11L,
	-2.3621847758873528928713382671927484629442E11L,
		0},
  { "ctgammal", ctgammal, +4.1L, +2.1L,
	-3.60250470914861418284562620959143149396635E0L,
	+1.26639445802995104654829531752728748651799E0L, 0},
  { "ctgammal", ctgammal, +4.1L, -2.1L,
	-3.60250470914861418284562620959143149396635E0L,
	-1.26639445802995104654829531752728748651799E0L, 0},
  { "ctgammal", ctgammal, -10.001L, +0.0L,
	-2.74926312890366307790512774322345359153964E-04L,
	+0.00000000000000000000000000000000000000000E+00L, 0},
  { "ctgammal", ctgammal, -15.001L, +0.0L,
	+7.62624375378243019824755124010594482406421E-10L,
	+0.00000000000000000000000000000000000000000E+00L, 0},
  { "ctgammal", ctgammal, -19.001L, +0.0L,
	+8.19626515819998213527541944686917060083919E-15L,
	+0.00000000000000000000000000000000000000000E+00L, 0},
  { "ctgammal", ctgammal, -20.0009765625L, 1.0L,
	+1.4095238549050756475118682300096961472153E-20L,
	+1.1336105645637884565210021753011180161902E-19L, 0},
  { "ctgammal", ctgammal, +20.001L, -1.0L,
	-1.17194578784682385638957859694786349174836E+17L,
	-2.01872028382587696223259133916128792966849E+16L, 0},
  { "ctgammal", ctgammal, -20.0009765625L, +0.0L,
	-4.1965747118999095358392333869351103363307E-16L,
	+0.0000000000000000000000000000000000000000E+00L, 0},
  { "ctgammal", ctgammal, +20.001L, +0.0L,
 	+1.22006990456562495874600162466039851777127E+17L,
	+0.00000000000000000000000000000000000000000E+00L, 0},
  { "ctgammal", ctgammal, +20.00, M_PI_2l,
	-5.09222065505852170951386495027086294931646E+15L,
	-1.14083188839310812140578978988348398098005E+17L, 0},
  { "ctgammal", ctgammal, -10.0L, 11.0L,
	+1.88965815515859412681832777147357374400030E-19L,
	+1.68603561429250551195150804052093225716265E-19L, 0},
  { "ctgammal", ctgammal, +10.0L, -11.0L,
	+1.70800206183801839174505709841176401901733E+02L,
	-1.62900082422625152423474833031818321301362E+03L, 0},
  { "ctgammal", ctgammal, -12.0L, +1.5625L,
	-7.7256822810600770072005801146452589845704E-11L,
	+7.3646514024840248173355097345288908744981E-11L,  0},
  { "ctgammal", ctgammal, -1.5L, +0.0L,
	+2.3632718012073547030642233111215269103967E+00L,
	+0.0000000000000000000000000000000000000000E+00L,  0},
  { "ctgammal", ctgammal, -2.5L, +0.0L,
	-9.4530872048294188122568932444861076415869E-01L,
	+0.0000000000000000000000000000000000000000E+00L,  0},
  { "ctgammal", ctgammal, -3.5L, +0.0L,
	+2.7008820585226910892162552127103164690248E-01L,
	+0.0000000000000000000000000000000000000000E+00L,  0},

  { "clgammal", clgammal, -20.0L, +79.0L,
	-2.1297308778751976010599847355093313569026E2L,
	+2.3135481408649533853040873427783779777603E2L,
	    0},
  { "clgammal", clgammal, -20.5L, +79.0L, 
	-2.1517448809009308863163012651937918386699E2L,
	+2.3044098659590049829633386338332350187754E2L,
	    0},
  { "clgammal", clgammal, +4.125L, +2.125L,
	+1.3625256036784048164604319421388171463447E0L,
	+2.8525474019523563409292929100120626164797E0L,    0},
  { "clgammal", clgammal, +4.125L, -2.125L,
	+1.3625256036784048164604319421388171463447E0L,
	-2.8525474019523563409292929100120626164797E0L,    0},  
  { "clgammal", clgammal,
	-2.0000976562500000000000000000000000000000E1L,
	+1.0000000000000000000000000000000000000000E0L,
	-4.3616038048909866376856649429072071283845E1L,
	-6.1384761187332935014593191118831774962721E1L,	0}, 
  { "clgammal", clgammal,
	+2.0000976562500000000000000000000000000000E1L,
	-1.0000000000000000000000000000000000000000E0L,
	+3.9317162196191172350858428817867355228747E1L,
	-2.9710116921617507487251478298443510152372E0L,	0},
  { "clgammal", clgammal,
	-2.0000976562500000000000000000000000000000E1L,
	+0.0000000000000000000000000000000000000000E0L,
	-3.5407092840138713477674562964289392719657E1L,
	-6.5973445725385658007715511048869560568141E1L,	0},
  { "clgammal", clgammal,
	-1.0000976562500000000000000000000000000000E1L,
	+0.0000000000000000000000000000000000000000E0L,
	-8.1752358775093991610978176096814198666058E0L,
	-3.4557519189487725623089077216074531726169E1L,
		0},
  { "clgammal", clgammal,
	-1.5000976562500000000000000000000000000000E1L,
	+0.0000000000000000000000000000000000000000E0L,
	-2.0970474811090406350643250190759942690898E1L,
	-5.0265482457436691815402294132472046147155E1L,
		0},
  { "clgammal", clgammal,
	-2.0001953125000000000000000000000000000000E1L,
	+0.0000000000000000000000000000000000000000E0L,
	-3.6103185114722972817877866364237396660096E1L,
	-6.5973445725385658007715511048869560568141E1L,
		0},
  { "clgammal", clgammal, -10.0L, +11.0L,
	-4.2819912321150102178361274654972147886802E1L,
	-5.5546720095852625829723715665556114571987E0L,
		0},
  { "clgammal", clgammal, +10.0L, -11.0L,
	 7.4011888473128456306813458819905920784576E0L,
	-2.6599069586433134715467690396042807588356E1L,
		0},
  { "clgammal", clgammal,
	-1.2000000000000000000000000000000000000000E1L,
	+1.5625000000000000000000000000000000000000E0L,
	-2.2960669115340119272182722186895587688421E1L,
	-3.5318997270899734941144532316414495132385E1L,
		0},
  { "clgammal", clgammal, 0.0L, 0.0L, LDBL_MAX, LDBL_MAX,
		0},
  {"null",   NULL, 0.0L, 0.0L, 0.0L, 0.0L, 0},
};


int
main (void);
int
main (void)
{
  long double complex (*fun1) (long double complex);
  long double complex a, y, z, w;
  int i, errs, tests;

  errs = 0;
  tests = 0;
  i = 0;
  for (;;)
    {
      fun1 = test1[i].func;
      if (fun1 == NULL)
	break;

      z = test1[i].real_arg + test1[i].imag_arg * I;
      w = (*(fun1)) (z);
      y = test1[i].real_ans + test1[i].imag_ans * I;
      a = y - w;
      if (a)
	{
	  errs += 1;
	  printf ("\n%s (%+#.20Lg%+#.20Lg*I)\n\tLine %2d: %+#.20Lg %+#.20Lg\n"
		  "\ts.b.     %+#.20Lg %+#.20Lg\n", test1[i].name, 
		  creall(z), cimagl(z), i + 1,
		  creall(w), cimagl(w), test1[i].real_ans, test1[i].imag_ans);
	  printf ("Diffs: Real = %+#.20Lg, Imag = %+#.20Lg\n",
		  creall(a), cimagl(a));
	}
      i += 1;
      tests += 1;
    }
  printf ("%d errors in %d tests\n", errs, tests);
  return 0;
}
