// ctans.c
		
/*  Taylor series expansion for cosh(2y) - cos(2x)	*/

static double ctans ( double complex z );

static double ctans (z)
     double complex z;
{
  double f, x, x2, y, y2, rn, t;
  double d;

  x = fabs (2.0 * creal(z));
  y = fabs (2.0 * cimag(z));

  x = redupi(x);

  x = x * x;
  y = y * y;
  x2 = 1.0;
  y2 = 1.0;
  f = 1.0;
  rn = 0.0;
  d = 0.0;
  do
    {
      rn += 1.0;
      f *= rn;
      rn += 1.0;
      f *= rn;
      x2 *= x;
      y2 *= y;
      t = y2 + x2;
      t /= f;
      d += t;

      rn += 1.0;
      f *= rn;
      rn += 1.0;
      f *= rn;
      x2 *= x;
      y2 *= y;
      t = y2 - x2;
      t /= f;
      d += t;
    }
  while (fabs(t/d) > DBL_EPSILON);
  return (d);
}
