/*	cpowl.c
 *
 *	Complex power function
 *
 *
 *
 * SYNOPSIS:
 *
 * long double complex cpowl();
 * long double complex a, z, w;
 *
 * w = cpowl (a, z);
 *
 *
 *
 * DESCRIPTION:
 *
 * Raises complex A to the complex Zth power.
 * Definition is per AMS55 # 4.2.8,
 * analytically equivalent to cpow(a,z) = cexp(z clog(a)).
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       9.4e-15     1.5e-15
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <math.h>
#include <float.h>

long double complex
cpowl(long double complex a, long double complex z)
{
    long double complex w;
    long double x, y, r, theta, absa, arga;

    x = creall(z);
    y = cimagl(z);
    absa = cabsl(a);
    if (absa == 0.0L)
    {
	return (0.0L + 0.0L * I);
    }
    arga = cargl(a);
    r = powl(absa, x);
    theta = x * arga;
    if (y != 0.0L)
    {
	r = r * expl(-y * arga);
	theta = theta + y * logl(absa);
    }
    w = r * cosl(theta) + (r * sinl(theta)) * I;
    return (w);
}
