/*	cpow.c
 *
 *	Complex power function
 *
 *
 *
 * SYNOPSIS:
 *
 * double complex cpow();
 * double complex a, z, w;
 *
 * w = cpow (a, z);
 *
 *
 *
 * DESCRIPTION:
 *
 * Raises complex A to the complex Zth power.
 * Definition is per AMS55 # 4.2.8,
 * analytically equivalent to cpow(a,z) = cexp(z clog(a)).
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       9.4e-15     1.5e-15
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>


double  complex
cpow(a, z)
double complex a, z;
{
    double complex w;
    double  x, y, r, theta, absa, arga;

    x = creal(z);
    y = cimag(z);
    absa = cabs(a);
    if (absa == 0.0)
    {
	return (0.0 + 0.0 * I);
    }
    arga = carg(a);
    r = pow(absa, x);
    theta = x * arga;
    if (y != 0.0)
    {
	r = r * exp(-y * arga);
	theta = theta + y * log(absa);
    }
    w = r * cos(theta) + (r * sin(theta)) * I;
    return (w);
}
