/*							ccotf()
 *
 *	Complex circular cotangent
 *
 *
 *
 * SYNOPSIS:
 *
 * void ccotf();
 * cmplxf z, w;
 *
 * ccotf( &z, &w );
 *
 *
 *
 * DESCRIPTION:
 *
 * If
 *     z = x + iy,
 *
 * then
 *
 *           sin 2x  -  i sinh 2y
 *     w  =  --------------------.
 *            cosh 2y  -  cos 2x
 *
 * On the real axis, the denominator has zeros at even
 * multiples of PI/2.  Near these points it is evaluated
 * by a Taylor series.
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       3.6e-7       5.7e-8
 * Also tested by ctan * ccot = 1 + i0.
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>

#include "redupif.c"
#include "ctansf.c"

float   complex
ccotf(float complex z)
{
    float complex w;
    float   d;


    d = coshf(2.0f * cimagf(z)) - cosf(2.0f * crealf(z));

    if (fabsf(d) < 0.25f)
	d = ctansf(z);

    if (d == 0.0f)
    {
	// mtherr( "ccotf", OVERFLOW );
	w = FLT_MAX + FLT_MAX * I;
	return (w);
    }
    w = sinf(2.0f * crealf(z)) / d - (sinhf(2.0f * cimagf(z)) / d) * I;
    return (w);
}
