/*							cabsf()
 *
 *	Complex absolute value
 *
 *
 *
 * SYNOPSIS:
 *
 * float cabsf();
 * float complex z;
 * float a;
 *
 * a = cabsf( z );
 *
 *
 *
 * DESCRIPTION:
 *
 *
 * If z = x + iy
 *
 * then
 *
 *       a = sqrt( x**2 + y**2 ).
 * 
 * Overflow and underflow are avoided by testing the magnitudes
 * of x and y before squaring.  If either is outside half of
 * the floating point full scale range, both are rescaled.
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       1.2e-7      3.4e-8
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>

# if 0
float
cabsf(float complex z)
{
    float   x, y;

    x = crealf(z);
    y = cimagf(z);

    return (hypotf(x, y));
}
# endif

#define PREC (FLT_MANT_DIG>>1)

float
cabsf(float complex z)
{
    float   x, y, b, re, im;
    int     ex, ey, e;

    re = fabsf((float)crealf(z));
    im = fabsf((float)cimagf(z));

    if (re == 0.0f)
	return (im);
    if (im == 0.0f)
	return (re);

    if ((isnanf) (crealf(z)))
	return (crealf(z));
    if ((isnanf) (cimagf(z)))
	return (cimagf(z));

    if ((isinff) (crealf(z)) || ((isinff) (cimag(z))))
    {
	return HUGE_VALF;
    }

    /* Get the exponents of the numbers */
    x = frexpf(re, &ex);
    y = frexpf(im, &ey);

    /* Check if one number is tiny compared to the other */
    e = ex - ey;
    if (e > PREC)
	return (re);
    if (e < -PREC)
	return (im);

    /* Find approximate exponent e of the geometric mean. */
    e = (ex + ey) >> 1;

    /* Rescale so mean is about 1 */
    x = ldexpf(re, -e);
    y = ldexpf(im, -e);

    /* Hypotenuse of the right triangle */
    b = sqrtf(x * x + y * y);

    /* Compute final exponent. */
    y = frexpf(b, &ey);
    ey = e + ey;

    /* Check for overflow. */
    if (ey > FLT_MAX_EXP)
    {
	//mtherr("cabsf", OVERFLOW);
	return (HUGE_VALF);
    }
    /* Check for underflow. */
    if (ey < FLT_MIN_EXP)
	;//return (0.0f);

    /* Undo scaling */
    b = ldexpf(b, e);
    return (b);
}
