// --------
// roundl.c
// --------
//
// Function roundl
//
// Synopsis
//
//	#include <math.h>
//	long double roundl(long double x);
//
// Description
//
// Function roundl rounds its argument to the nearest integer
// value in floating-point format, rounding halfway cases away
// from zero, regardless of the current rounding direction.
//
// Returns
//
// Function roundl returns the rounded integer value.
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, March 2002, updated September 2003
//
#include <math.h>

long double
roundl(long double Arg)
{
    long double	FracPart, IntPart;

    FracPart = modfl(Arg, &IntPart);

    if (fabsl(FracPart) >= 0.5L)
           IntPart += copysignl(1.0L, IntPart);

    return IntPart;
}
