// ------------
// nrbyintf.c
// ------------
//
// From ISO C99:
//
// Function nearbyintf
//
// Synopsis
//
//	#include <math.h>
//	float nearbyintf(float x);
//
// Description
//
// Function nearbyintf rounds its argument to an integer value
// in floating-point format, using the current rounding direction.
// Function nearbyintf uses IEC 60559 rounding according to the
// current rounding direction.	It does not raise the inexact
// exception if the result differs in value from the argument.
//
// Returns
//
// Function nearbyintf returns the rounded integer value.
//
// Remarks
//
// Function nearbyintf differs from the rint function only in that
// the floating point inexact exception isn't raised whenever the
// result differs in value from the argument.
//
// o  nearbyintf(+-0) returns +-0 (for all rounding modes).
//
// o  nearbyintf(+-Inf) returns +-Inf (for all rounding modes).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, September 2003
//

#include <fdlibml.h>
#include <fenv.h>

float nearbyintf(float Arg)
{
    fenv_t	SavedEnv;
    float 	Retval;
    int         CurrentExcepts;

    CurrentExcepts = fetestexcept(FE_ALL_EXCEPT);
    feholdexcept(&SavedEnv);

    ROUND_TO_INT(Arg, Retval);

    fesetenv(&SavedEnv);
    feclearexcept(FE_ALL_EXCEPT);
    __fp_raise_except(CurrentExcepts);

    return Retval;
}
