// --------
// mpyull.c
// --------
//
// Function MpyUll
//
// Multiplies two unsigned long long int arguments at ArgA and ArgB.
//
// Returns a 128-bit result as two unsigned long long int values in
// space provided in the calling sequence at HeadC and TailC.
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, March 2004
//
//
// ----------------------------------------------------------------
#include <fdlibml.h>

void MpyUll(ULLONG ArgA, ULLONG ArgB, ULLONG *HeadC, ULLONG *TailC)
{
    ULLONG  hA, tA, hB, tB, hC, tC;
    ULLONG  CrsPrdA, CrsPrdB;

    hA = ArgA >> 32;
    tA = (ULONG)ArgA;
    hB = ArgB >> 32;
    tB = (ULONG)ArgB;

    CrsPrdA = tA * hB;
    CrsPrdB = hA * tB;
    CrsPrdA += CrsPrdB;

    hC = hA * hB;
    hC += ((ULLONG)(CrsPrdA < CrsPrdB) << 32) + (CrsPrdA >> 32);

    tC = tA * tB;
    CrsPrdA <<= 32;
    tC += CrsPrdA;
    hC += (tC < CrsPrdA);

    *TailC = tC;
    *HeadC = hC;
}
