/*
 * Written by J.T. Conklin <jtc@netbsd.org>.
 * Change for long double by Ulrich Drepper <drepper@cygnus.com>.
 * Modified for DJGPP/GNU by KB Williams <kbwms@aol.com>,
 * January 2002
 * Public domain.
 */

#if defined(LIBM_SCCS) && !defined(lint)
static char rcsid[] = "$NetBSD: $";
#endif

/*
 * isinfl(x) returns 1 if x is inf, -1 if x is -inf, else 0;
 * no branching!
 */

#include <fdlibml.h>

int
isinfl (long double x)
{
	int	se, hx, lx;
	GET_LDOUBLE_WORDS(se,hx,lx,x+0);
	lx |= (hx & 0x7fffffff) | ((se & 0x7fff) ^ 0x7fff);
	lx |= -lx;
	se &= 0x8000;
	return ~(lx >> 31) & (1 - (se >> 14));
}
