/* ilogbl.c -- long double version of s_ilogb.c.
 * Adapted to long double for DJGPP/GNU by
 * KB Williams, kbwms@aol.com, January 2002 &
 * January 2004.
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */
/* The following is excerpted from C99 dated 12/18/1999
 *
 * The ilogbl() function extracts the exponent of x as a
 * signed int value.
 *	If x is zero, it computes the value FP_ILOGB0;
 *	if x is infinite, it computes the value INT_MAX;
 *	if x is a NaN, it computes the value FP_ILOGBNAN.
 * Otherwise, it is equivalent to calling function logbl()
 * and casting the returned value to type int.
 */

#include <errno.h>
#include <fdlibml.h>

#ifdef __STDC__
int ilogbl(long double Arg)
#else
int ilogbl(Arg)
long double Arg;
#endif
{
    int	    BinExp, ExpBits;
    LLONG   FracBits;

    GET64_LDOUBLE(ExpBits, FracBits, Arg);

    ExpBits &= 0x7fff;			/* Remove sign bit */

    if (ExpBits == 0)
    {
    	if (FracBits == 0)
        {
	    __math_set_errno(EDOM);
	    BinExp = FP_ILOGB0;		/* For Arg == 0 */
        }
	else
	{
	    for (; FracBits > 0; --ExpBits, FracBits <<= 1)
	    	;
	    BinExp = ExpBits - 0x3ffe;
	}
    }	    				       
    else if (ExpBits == 0x7fff)
    {
	__math_set_errno(EDOM);

    	if (isinfl(Arg))
	{
	    BinExp = INT_MAX;
	}
	else
	{		    		       
	    BinExp = FP_ILOGBNAN;	/* For Inf or NaN */
	}    		
    }
    else
    {
	BinExp = ExpBits - 0x3fff;	/* For |Arg| > 0 */
    }

    return BinExp;
}
