// Function fpclassifyl
//
// Synopsis
//
//	#include <fdlibml.h>
//	int fpclassifyl(long double x);
//
// Description
//
// Function fpclassifyl classifies its argument value as
// NaN, infinite, normal, subnormal, or zero.
//
// Returns
//
// Function fpclassifyl returns the value of the number
// classification appropriate to the value of its argument.
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, March 2002
//

#include <fdlibml.h>

/* Floating-point arguments are classified as follows
   (per ISO C99 section 7.12 paragraph 6):

   Type		Macro
   ----		-----
   Infinite	FP_INFINITE,
   NaN		FP_NAN,
   Normal	FP_NORMAL,
   Subnormal	FP_SUBNORMAL,
   Zero		FP_ZERO

   Expansions of these macros are given in fdlibml.h.
 */

#define HI_BIT	0x8000000000000000ULL
#define LO_BITS 0x7fffffffffffffffULL

int
fpclassifyl (long double Arg)
{
  UINT		Exp_and_Sign, ExpBits;
  ULLONG	FracBits;

  GET64_LDOUBLE(Exp_and_Sign, FracBits, Arg);

  ExpBits = Exp_and_Sign & 0x7fff;

  return   ((ExpBits | FracBits) == 0)			   ? FP_ZERO
	:  ((ExpBits | (FracBits & HI_BIT)) == 0)	   ? FP_SUBNORMAL
	:  (ExpBits == 0x7fff) ? (FracBits & LO_BITS) == 0 ? FP_INFINITE
							   : FP_NAN
	: FP_NORMAL;
}
