// ------------------------------------------------------------------
// fminf.c - returns the minimum numeric value of a pair of arguments
// ------------------------------------------------------------------
//
//  Synopsis:
//
//	#include <math.h>
//
//	float x, y, z, fminf()
//
//	z = fminf(x, y);
//
//  If either x or y is a NaN, return the numeric value
//  If both x and y are NaNs, return a NaN
//
//
#include <fdlibml.h>

float	fminf(float x, float y)
{
    float    Retval;

    if (isnanf(x) || isnanf(y))
    {
	Retval = isnanf(y) ? x : y;
    }
    else if (x == 0.0 && y == 0.0)
    {
	int	Sign = signbitf(x);	// extract sign bit
					// return -0 if signs differ
	Retval = (Sign) ? x : y;
    }
    else
    {
	Retval = (x < y) ? x : y;
    }
    return Retval;
}
