/* -------- */
/* floorl.c */
/* -------- */
/*
 * floorl() returns the largest integer not greater than Arg.
 * It truncates toward minus infinity.
*/
/*
 * Written for DJGPP/GCC by KB Williams,
 * kbwms@aol.com, March 2001
*/

#include <fenv.h>
#include <fdlibml.h>

# if defined __STDC__
long double floorl(long double Arg)
#else
long double floorl(Arg)
long double Arg;
# endif
{
    LDBL    Retval;
    int	    CrntRndDir;

    CrntRndDir = fegetround();
    fesetround(FE_DOWNWARD);

    ROUND_TO_INT(Arg, Retval);

    fesetround(CrntRndDir);

    return Retval;
}
# if defined TEST_FLOOR
#include <fdlibml.h>
LDBL	floorl(LDBL);

#include <stdio.h>
#include <stdlib.h>
int
main(void)
{
    long double Arg, Retval;

    Arg = 0.0L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -0.0L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = INFINITYL;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -INFINITYL;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = NAN;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 0.1L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -0.1L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 10.1L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -10.1L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 10.0L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -10.0L;
    Retval = floorl(Arg);
    printf("floorl(%+Lg) = %+Lg\n", Arg, Retval);
    exit(0);
}
# endif
