// --------------
// fgetexcptflg.c
// --------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
//  The fegetexceptflag function
//
//  Synopsis
//
//    #include <fenv.h>
//
//    int
//    fegetexceptflag(fexcept_t *flagp, int Excepts);
//
//  Description
//
//    Function fegetexceptflag() stores an implementation-
//    defined representation of the exception flags indicated
//    by the argument Excepts in the object pointed to by the
//    argument flagp.  These exception flags may include:
//
//	FE_INVALID	Invalid operation
//	FE_DENORMAL	Denormalized operand  (added by KBW)
//	FE_DIVBYZERO	Division by zero
//	FE_OVERFLOW	Overflow
//	FE_UNDERFLOW	Underflow
//	FE_INEXACT	Precision loss
//
//   where Excepts is any one or a combination (logical or) of
//   the exceptions (macros) listed above.  The numerical value
//   of each macro is given in <fenv.h>.
//
// Returns
//
//   Function fegetexceptflag() returns in *flagp the value of
//   the bitwise OR of currently-set exception flags and flags
//   indicated in argument Excepts.
//
//   The returned-value of the function is -1 if flagp is NULL,
//   else zero.
//

#include <fenv.h>

int
fegetexceptflag (fexcept_t *Flagp, int Excepts)
{
    int	    Retval;

    if (Flagp)
    {
	Retval = 0;
	*Flagp = fetestexcept(Excepts);
    }
    else
    {
	Retval = -1;
    }

    return Retval;
}
