// ------------
// fesetround.c
// ------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function fesetround()
//
// Synopsis
//
//	   #include <fenv.h>
//	   int fesetround(int RndDirSpec);
//
// Description
//
// Function fesetround() establishes the rounding direction
// represented by its argument RndDirSpec.  Unless RndDirSpec
// equals the value of a rounding-direction macro, direction
// of rounding remains unchanged.
//
// Returns
//
// Function fesetround() returns zero if and only if RndDirSpec
// matches the value of a rounding direction macro.

#include <fenv.h>

#define AV	__asm__ __volatile__

#define SET_ROUND(NewRnd)			\
    {						\
	unsigned short CtrlWrd;			\
	AV  ("FSTCW %0" : "=m" (*&CtrlWrd));	\
	CtrlWrd &= ~FE_ALL_ROUND;		\
	CtrlWrd |= NewRnd;			\
	AV  ("FLDCW %0" : : "m" (*&CtrlWrd));	\
    }

int
fesetround(int NewRound)
{
    int	    Retval;

    NewRound &= FE_ALL_ROUND;
    
    if ((NewRound == FE_DOWNWARD) 
    ||	(NewRound == FE_TONEAREST)
    ||	(NewRound == FE_TOWARDZERO)
    ||	(NewRound == FE_UPWARD))	   
    {
	SET_ROUND(NewRound);
	if (fegetround() == NewRound)
	{		
	    Retval = 0;			// No Error
	}
	else
	{
	    Retval = -1;		// Hardware Failure
	}    			    		       
    }
    else	    			// NewRound Not legitimate       
    {
	Retval = -1;			// Return Error
    }

    return Retval;
}
