// --------------
// feraiseexcpt.c
// --------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function feraiseexcept() attempts to raise supported exceptions
// represented by its argument.	 These exceptions include:
//
//	   FE_INVALID	   Invalid operation
//	   FE_DENORMAL	   Denormalized operand	 (added by KBW)
//	   FE_DIVBYZERO	   Division by zero
//	   FE_OVERFLOW	   Overflow
//	   FE_UNDERFLOW	   Underflow
//	   FE_INEXACT	   Precision loss
//
// The order in which these exceptions are raised is unspecified
// except as stated in F.7.6.  Whether function feraiseexcept() 
// additionally raises the inexact exception whenever it raises
// the overflow or underflow exception is implementation-defined.
//
// Synopsis:
//
//   #include <fenv.h>
//   int feraiseexcept(int Excepts);
//
//   where Excepts is any one or a combination (logical or) of
//   the exceptions (macros) listed above.  The numerical value
//   of each macro is given in <fenv.h>.
//
//   Return value is 0 (no errors) if Excepts is zero or if all
//   specified exceptions were raised successfully.

#include <fenv.h>

#define AV	__asm__ __volatile__

#define RAISE_EXCEPTS(Xcpt)			\
    {						\
	fenv_t	FPU_Env;			\
	AV ("FSTENV %0" : "=m" (*&FPU_Env));	\
	FPU_Env.Status_Word |= Xcpt;		\
	AV ("FLDENV %0" : : "m" (*&FPU_Env));	\
	AV ("FWAIT");				\
    }

// -----------------------------------------
// Raises exceptions as indicated by Excepts
// -----------------------------------------
int
feraiseexcept(int Excepts)
{
    int	    WantedExcepts;

    WantedExcepts = FE_ALL_EXCEPT & Excepts;

    RAISE_EXCEPTS(WantedExcepts)
    		
    return (fetestexcept(WantedExcepts) != (WantedExcepts));
}
